/*
 * Decompiled with CFR 0.152.
 */
package de.learnlib.datastructure.observationtable;

import de.learnlib.api.AccessSequenceTransformer;
import de.learnlib.datastructure.observationtable.Inconsistency;
import de.learnlib.datastructure.observationtable.Row;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.Signed;
import net.automatalib.words.Alphabet;
import net.automatalib.words.Word;

@ParametersAreNonnullByDefault
public interface ObservationTable<I, D>
extends AccessSequenceTransformer<I> {
    public static final int NO_DISTINGUISHING_SUFFIX = -1;

    public Alphabet<I> getInputAlphabet();

    @Nonnull
    default public Collection<Word<I>> getAllPrefixes() {
        Collection<Word<I>> shortPrefixes = this.getShortPrefixes();
        Collection<Word<I>> longPrefixes = this.getLongPrefixes();
        ArrayList<Word<I>> result = new ArrayList<Word<I>>(shortPrefixes.size() + longPrefixes.size());
        result.addAll(shortPrefixes);
        result.addAll(longPrefixes);
        return result;
    }

    @Nonnull
    default public Collection<Word<I>> getShortPrefixes() {
        Collection<Row<I>> spRows = this.getShortPrefixRows();
        return spRows.stream().map(Row::getLabel).collect(Collectors.toList());
    }

    @Nonnull
    default public Collection<Word<I>> getLongPrefixes() {
        Collection<Row<I>> lpRows = this.getLongPrefixRows();
        return lpRows.stream().map(Row::getLabel).collect(Collectors.toList());
    }

    @Nonnull
    public Collection<Row<I>> getShortPrefixRows();

    @Nonnull
    public Collection<Row<I>> getLongPrefixRows();

    @Nullable
    public Row<I> getRow(int var1);

    @Nullable
    default public Row<I> getRow(Word<I> prefix) {
        for (Row<I> row : this.getAllRows()) {
            if (!prefix.equals(row.getLabel())) continue;
            return row;
        }
        return null;
    }

    @Nonnull
    default public Collection<Row<I>> getAllRows() {
        Collection<Row<I>> spRows = this.getShortPrefixRows();
        Collection<Row<I>> lpRows = this.getLongPrefixRows();
        ArrayList<Row<I>> result = new ArrayList<Row<I>>(spRows.size() + lpRows.size());
        result.addAll(spRows);
        result.addAll(lpRows);
        return result;
    }

    default public int numberOfRows() {
        return this.getShortPrefixRows().size() + this.getLongPrefixRows().size();
    }

    default public int numberOfShortPrefixRows() {
        return this.getShortPrefixRows().size();
    }

    default public int numberOfLongPrefixRows() {
        return this.getLongPrefixRows().size();
    }

    public int numberOfDistinctRows();

    default public boolean isClosed() {
        return this.findUnclosedRow() == null;
    }

    @Nullable
    default public Row<I> findUnclosedRow() {
        boolean[] spContents = new boolean[this.numberOfDistinctRows()];
        for (Row<I> spRow : this.getShortPrefixRows()) {
            spContents[spRow.getRowContentId()] = true;
        }
        for (Row<I> lpRow : this.getLongPrefixRows()) {
            if (spContents[lpRow.getRowContentId()]) continue;
            return lpRow;
        }
        return null;
    }

    @Nullable
    default public Word<I> findDistinguishingSuffix(Inconsistency<I> inconsistency) {
        int suffixIndex = this.findDistinguishingSuffixIndex(inconsistency);
        if (suffixIndex != -1) {
            return null;
        }
        return this.getSuffix(suffixIndex);
    }

    @Nullable
    default public Word<I> findDistinguishingSuffix(Row<I> row1, Row<I> row2) {
        int suffixIndex = this.findDistinguishingSuffixIndex(row1, row2);
        if (suffixIndex != -1) {
            return null;
        }
        return this.getSuffix(suffixIndex);
    }

    @Signed
    default public int findDistinguishingSuffixIndex(Inconsistency<I> inconsistency) {
        Row<I> row1 = inconsistency.getFirstRow();
        Row<I> row2 = inconsistency.getSecondRow();
        int symIdx = this.getInputAlphabet().getSymbolIndex(inconsistency.getSymbol());
        return this.findDistinguishingSuffixIndex(row1.getSuccessor(symIdx), row2.getSuccessor(symIdx));
    }

    @Signed
    default public int findDistinguishingSuffixIndex(Row<I> row1, Row<I> row2) {
        for (int i = 0; i < this.getSuffixes().size(); ++i) {
            if (Objects.equals(this.cellContents(row1, i), this.cellContents(row2, i))) continue;
            return i;
        }
        return -1;
    }

    @Nonnull
    default public Word<I> getSuffix(int index) {
        return this.getSuffixes().get(index);
    }

    @Nonnull
    public List<Word<I>> getSuffixes();

    default public int numberOfSuffixes() {
        return this.getSuffixes().size();
    }

    default public boolean isConsistent() {
        return this.findInconsistency() == null;
    }

    @Nullable
    default public Inconsistency<I> findInconsistency() {
        Row[] canonicalRows = new Row[this.numberOfDistinctRows()];
        Alphabet<I> alphabet = this.getInputAlphabet();
        for (Row<I> spRow : this.getShortPrefixRows()) {
            int contentId = spRow.getRowContentId();
            Row canRow = canonicalRows[contentId];
            if (canRow == null) {
                canonicalRows[contentId] = spRow;
                continue;
            }
            for (int i = 0; i < alphabet.size(); ++i) {
                int canSuccContent;
                Row<I> spRowSucc = spRow.getSuccessor(i);
                if (spRowSucc == null) continue;
                Row canRowSucc = canRow.getSuccessor(i);
                if (!1.$assertionsDisabled && canRowSucc == null) {
                    throw new AssertionError();
                }
                int spSuccContent = spRowSucc.getRowContentId();
                if (spSuccContent == (canSuccContent = canRowSucc.getRowContentId())) continue;
                return new Inconsistency<Object>(canRow, spRow, alphabet.getSymbol(i));
            }
        }
        return null;
    }

    default public Row<I> getRowSuccessor(Row<I> row, I sym) {
        return row.getSuccessor(this.getInputAlphabet().getSymbolIndex(sym));
    }

    public List<D> rowContents(Row<I> var1);

    default public D cellContents(Row<I> row, int columnId) {
        return this.rowContents(row).get(columnId);
    }

    static {
        if (1.$assertionsDisabled) {
            // empty if block
        }
    }
}

