/*
 * Decompiled with CFR 0.152.
 */
package de.learnlib.datastructure.observationtable;

import de.learnlib.datastructure.observationtable.ObservationTable;
import de.learnlib.datastructure.observationtable.reader.ObservationTableReader;
import de.learnlib.datastructure.observationtable.writer.ObservationTableHTMLWriter;
import de.learnlib.datastructure.observationtable.writer.ObservationTableWriter;
import java.awt.Desktop;
import java.io.File;
import java.io.IOException;
import java.io.Writer;
import java.util.function.Function;
import javax.annotation.ParametersAreNonnullByDefault;
import net.automatalib.commons.util.IOUtil;
import net.automatalib.words.Alphabet;
import net.automatalib.words.Word;

@ParametersAreNonnullByDefault
public final class OTUtils {
    private static final String HTML_FILE_HEADER = "<!doctype html>" + System.lineSeparator() + "<html><head>" + System.lineSeparator() + "<meta charset=\"UTF-8\">" + System.lineSeparator() + "<style type=\"text/css\">" + System.lineSeparator() + "table.learnlib-observationtable { border-width: 1px; border: solid; }" + System.lineSeparator() + "table.learnlib-observationtable th.suffixes-header { text-align: center; }" + System.lineSeparator() + "table.learnlib-observationtable th.prefix { vertical-align: top; }" + System.lineSeparator() + "table.learnlib-observationtable .suffix-column { text-align: left; }" + System.lineSeparator() + "table.learnlib-observationtable tr { border-width: 1px; border: solid; }" + System.lineSeparator() + "table.learnlib-observationtable tr.long-prefix { background-color: #dfdfdf; }" + System.lineSeparator() + "</style></head>" + System.lineSeparator() + "<body>" + System.lineSeparator();
    private static final String HTML_FILE_FOOTER = "</body></html>" + System.lineSeparator();

    private OTUtils() {
        throw new AssertionError((Object)"Constructor should never be invoked");
    }

    public static <I, D> String toString(ObservationTable<I, D> table, ObservationTableWriter<I, D> writer) {
        StringBuilder sb = new StringBuilder();
        writer.write(table, sb);
        return sb.toString();
    }

    public static <I, D> ObservationTable<I, D> fromString(String source, Alphabet<I> alphabet, ObservationTableReader<I, D> reader) {
        return reader.read(source, alphabet);
    }

    public static <I, D> void writeHTMLToFile(ObservationTable<I, D> table, File file) throws IOException {
        OTUtils.writeHTMLToFile(table, file, Object::toString, Object::toString);
    }

    public static <I, D> void writeHTMLToFile(ObservationTable<I, D> table, File file, Function<? super Word<? extends I>, ? extends String> wordToString, Function<? super D, ? extends String> outputToString) throws IOException {
        try (Writer w = IOUtil.asBufferedUTF8Writer((File)file);){
            w.write(HTML_FILE_HEADER);
            ObservationTableHTMLWriter<I, D> otWriter = new ObservationTableHTMLWriter<I, D>(wordToString, outputToString);
            otWriter.write(table, w);
            w.write(HTML_FILE_FOOTER);
        }
    }

    public static <I, D> void displayHTMLInBrowser(ObservationTable<I, D> table) throws IOException, UnsupportedOperationException {
        OTUtils.displayHTMLInBrowser(table, Object::toString, Object::toString);
    }

    public static <I, D> void displayHTMLInBrowser(ObservationTable<I, D> table, Function<? super Word<? extends I>, ? extends String> wordToString, Function<? super D, ? extends String> outputToString) throws IOException, UnsupportedOperationException {
        File tempFile = File.createTempFile("learnlib-ot", ".html");
        OTUtils.writeHTMLToFile(table, tempFile, wordToString, outputToString);
        Desktop desktop = Desktop.getDesktop();
        desktop.browse(tempFile.toURI());
    }
}

