/*
 * Decompiled with CFR 0.152.
 */
package de.learnlib.datastructure.observationtable;

import de.learnlib.api.oracle.MembershipOracle;
import de.learnlib.datastructure.observationtable.AbstractObservationTable;
import de.learnlib.datastructure.observationtable.Row;
import de.learnlib.datastructure.observationtable.RowImpl;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import net.automatalib.words.Alphabet;
import net.automatalib.words.Word;
import net.automatalib.words.impl.Alphabets;

public final class GenericObservationTable<I, D>
extends AbstractObservationTable<I, D> {
    private transient int alphabetSize;

    public GenericObservationTable(Alphabet<I> alphabet) {
        super(alphabet);
        this.alphabetSize = alphabet.size();
    }

    @Override
    public List<List<Row<I>>> initialize(List<Word<I>> initialShortPrefixes, List<Word<I>> initialSuffixes, MembershipOracle<I, D> oracle) {
        Row succRow;
        this.checkInitialShortPrefixes(initialShortPrefixes);
        List<Word<I>> suffixes = this.initializeSuffixes(initialSuffixes);
        Alphabet alphabet = this.getInputAlphabet();
        int numPrefixes = alphabet.size() * initialShortPrefixes.size() + 1;
        int numSuffixes = suffixes.size();
        ArrayList queries = new ArrayList(numPrefixes * numSuffixes);
        for (Word<I> sp : initialShortPrefixes) {
            this.createSpRow(sp);
            GenericObservationTable.buildQueries(queries, sp, suffixes);
        }
        for (Object spRow : this.shortPrefixRows) {
            Word sp = ((RowImpl)spRow).getLabel();
            for (int i = 0; i < alphabet.size(); ++i) {
                Object sym = alphabet.getSymbol(i);
                Word lp = sp.append(sym);
                succRow = this.getRow(lp);
                if (succRow == null) {
                    succRow = this.createLpRow(lp);
                    GenericObservationTable.buildQueries(queries, lp, suffixes);
                }
                ((RowImpl)spRow).setSuccessor(i, succRow);
            }
        }
        oracle.processQueries(queries);
        Iterator queryIt = queries.iterator();
        for (RowImpl spRow : this.shortPrefixRows) {
            ArrayList rowContents = new ArrayList(numSuffixes);
            GenericObservationTable.fetchResults(queryIt, rowContents, numSuffixes);
            if (this.processContents(spRow, rowContents, true)) continue;
            this.initialConsistencyCheckRequired = true;
        }
        int distinctSpRows = this.numberOfDistinctRows();
        ArrayList<List<Row<I>>> unclosed = new ArrayList<List<Row<I>>>();
        for (RowImpl spRow : this.shortPrefixRows) {
            for (int i = 0; i < alphabet.size(); ++i) {
                int id;
                succRow = spRow.getSuccessor(i);
                if (((RowImpl)succRow).isShortPrefixRow()) continue;
                ArrayList rowContents = new ArrayList(numSuffixes);
                GenericObservationTable.fetchResults(queryIt, rowContents, numSuffixes);
                if (this.processContents(succRow, rowContents, false)) {
                    unclosed.add(new ArrayList());
                }
                if ((id = ((RowImpl)succRow).getRowContentId()) < distinctSpRows) continue;
                ((List)unclosed.get(id - distinctSpRows)).add(succRow);
            }
        }
        return unclosed;
    }

    @Override
    public List<List<Row<I>>> toShortPrefixes(List<Row<I>> lpRows, MembershipOracle<I, D> oracle) {
        ArrayList<Row> freshSpRows = new ArrayList<Row>();
        ArrayList freshLpRows = new ArrayList();
        Alphabet alphabet = this.getInputAlphabet();
        for (Row<I> r : lpRows) {
            Row row = this.getRow(r.getRowId());
            if (((RowImpl)row).isShortPrefixRow()) {
                if (((RowImpl)row).hasContents()) continue;
                freshSpRows.add(row);
            } else {
                this.makeShort(row);
                if (!((RowImpl)row).hasContents()) {
                    freshSpRows.add(row);
                }
            }
            Word prefix = ((RowImpl)row).getLabel();
            for (int i = 0; i < alphabet.size(); ++i) {
                Iterator sym = alphabet.getSymbol(i);
                Word word = prefix.append((Object)sym);
                RowImpl lpRow = this.getRow(word);
                if (lpRow == null) {
                    lpRow = this.createLpRow(word);
                    freshLpRows.add(lpRow);
                }
                ((RowImpl)row).setSuccessor(i, lpRow);
            }
        }
        List suffixes = this.getSuffixes();
        int numSuffixes = suffixes.size();
        int numFreshRows = freshSpRows.size() + freshLpRows.size();
        ArrayList queries = new ArrayList(numFreshRows * numSuffixes);
        GenericObservationTable.buildRowQueries(queries, freshSpRows, suffixes);
        GenericObservationTable.buildRowQueries(queries, freshLpRows, suffixes);
        oracle.processQueries(queries);
        Iterator queryIt = queries.iterator();
        for (RowImpl rowImpl : freshSpRows) {
            ArrayList contents = new ArrayList(numSuffixes);
            GenericObservationTable.fetchResults(queryIt, contents, numSuffixes);
            this.processContents(rowImpl, contents, true);
        }
        int numSpRows = this.numberOfDistinctRows();
        ArrayList<List<Row<I>>> arrayList = new ArrayList<List<Row<I>>>();
        for (RowImpl rowImpl : freshLpRows) {
            int id;
            ArrayList contents = new ArrayList(numSuffixes);
            GenericObservationTable.fetchResults(queryIt, contents, numSuffixes);
            if (this.processContents(rowImpl, contents, false)) {
                arrayList.add(new ArrayList());
            }
            if ((id = rowImpl.getRowContentId()) < numSpRows) continue;
            ((List)arrayList.get(id - numSpRows)).add(rowImpl);
        }
        return arrayList;
    }

    @Override
    public List<List<Row<I>>> addAlphabetSymbol(I symbol, MembershipOracle<I, D> oracle) {
        Alphabet alphabet = this.getInputAlphabet();
        if (!alphabet.containsSymbol(symbol)) {
            Alphabets.toGrowingAlphabetOrThrowException(alphabet).addSymbol(symbol);
        }
        int newAlphabetSize = alphabet.size();
        if (this.isInitialized() && this.alphabetSize < newAlphabetSize) {
            this.alphabetSize = newAlphabetSize;
            int newSymbolIdx = alphabet.getSymbolIndex(symbol);
            List shortPrefixes = this.shortPrefixRows;
            ArrayList newLongPrefixes = new ArrayList(shortPrefixes.size());
            for (RowImpl prefix : shortPrefixes) {
                prefix.ensureInputCapacity(newAlphabetSize);
                Word newLongPrefix = prefix.getLabel().append(symbol);
                RowImpl longPrefixRow = this.createLpRow(newLongPrefix);
                newLongPrefixes.add(longPrefixRow);
                prefix.setSuccessor(newSymbolIdx, longPrefixRow);
            }
            int numLongPrefixes = newLongPrefixes.size();
            int numSuffixes = this.numberOfSuffixes();
            ArrayList queries = new ArrayList(numLongPrefixes * numSuffixes);
            GenericObservationTable.buildRowQueries(queries, newLongPrefixes, this.getSuffixes());
            oracle.processQueries(queries);
            Iterator queryIterator = queries.iterator();
            ArrayList<List<Row<I>>> result = new ArrayList<List<Row<I>>>(numLongPrefixes);
            for (RowImpl rowImpl : newLongPrefixes) {
                ArrayList contents = new ArrayList(numSuffixes);
                GenericObservationTable.fetchResults(queryIterator, contents, numSuffixes);
                if (!this.processContents(rowImpl, contents, false)) continue;
                result.add(Collections.singletonList(rowImpl));
            }
            return result;
        }
        return Collections.emptyList();
    }
}

