/*
 * Decompiled with CFR 0.152.
 */
package de.learnlib.datastructure.observationtable;

import de.learnlib.api.oracle.MembershipOracle;
import de.learnlib.api.query.DefaultQuery;
import de.learnlib.datastructure.observationtable.MutableObservationTable;
import de.learnlib.datastructure.observationtable.Row;
import de.learnlib.datastructure.observationtable.RowImpl;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nonnull;
import net.automatalib.words.Alphabet;
import net.automatalib.words.Word;

public abstract class AbstractObservationTable<I, D>
implements MutableObservationTable<I, D>,
Serializable {
    private static final Integer NO_ENTRY = null;
    protected final List<RowImpl<I>> shortPrefixRows = new ArrayList<RowImpl<I>>();
    private final List<RowImpl<I>> longPrefixRows = new ArrayList<RowImpl<I>>();
    private final List<RowImpl<I>> allRows = new ArrayList<RowImpl<I>>();
    private final List<List<D>> allRowContents = new ArrayList<List<D>>();
    private final List<RowImpl<I>> canonicalRows = new ArrayList<RowImpl<I>>();
    private final Map<List<D>, Integer> rowContentIds = new HashMap<List<D>, Integer>();
    private final Map<Word<I>, RowImpl<I>> rowMap = new HashMap<Word<I>, RowImpl<I>>();
    private final List<Word<I>> suffixes = new ArrayList<Word<I>>();
    private final Set<Word<I>> suffixSet = new HashSet<Word<I>>();
    private transient Alphabet<I> alphabet;
    private int numRows;
    protected boolean initialConsistencyCheckRequired;

    public AbstractObservationTable(Alphabet<I> alphabet) {
        this.alphabet = alphabet;
    }

    protected static <I, D> void buildQueries(List<DefaultQuery<I, D>> queryList, Word<I> prefix, List<? extends Word<I>> suffixes) {
        for (Word<I> suffix : suffixes) {
            queryList.add(new DefaultQuery(prefix, suffix));
        }
    }

    protected void checkInitialShortPrefixes(List<Word<I>> initialShortPrefixes) {
        if (!this.allRows.isEmpty()) {
            throw new IllegalStateException("Called initialize, but there are already rows present");
        }
        if (!AbstractObservationTable.checkPrefixClosed(initialShortPrefixes)) {
            throw new IllegalArgumentException("Initial short prefixes are not prefix-closed");
        }
        if (!initialShortPrefixes.get(0).isEmpty()) {
            throw new IllegalArgumentException("First initial short prefix MUST be the empty word!");
        }
    }

    protected List<Word<I>> initializeSuffixes(List<Word<I>> initialSuffixes) {
        if (!this.suffixSet.isEmpty() || !this.suffixes.isEmpty()) {
            throw new IllegalStateException("Trying to initialize suffixes, but there are already suffixes present");
        }
        for (Word<I> suffix : initialSuffixes) {
            if (!this.suffixSet.add(suffix)) continue;
            this.suffixes.add(suffix);
        }
        return this.suffixes;
    }

    private static <I> boolean checkPrefixClosed(Collection<? extends Word<I>> initialShortPrefixes) {
        HashSet<Word<I>> prefixes = new HashSet<Word<I>>(initialShortPrefixes);
        for (Word<I> pref : initialShortPrefixes) {
            if (pref.isEmpty() || prefixes.contains(pref.prefix(-1))) continue;
            return false;
        }
        return true;
    }

    protected RowImpl<I> createSpRow(Word<I> prefix) {
        RowImpl<I> newRow = new RowImpl<I>(prefix, this.numRows++, this.alphabet.size());
        this.allRows.add(newRow);
        this.rowMap.put(prefix, newRow);
        this.shortPrefixRows.add(newRow);
        return newRow;
    }

    protected RowImpl<I> createLpRow(Word<I> prefix) {
        RowImpl<I> newRow = new RowImpl<I>(prefix, this.numRows++);
        this.allRows.add(newRow);
        this.rowMap.put(prefix, newRow);
        int idx = this.longPrefixRows.size();
        this.longPrefixRows.add(newRow);
        newRow.setLpIndex(idx);
        return newRow;
    }

    protected static <I, D> void fetchResults(Iterator<DefaultQuery<I, D>> queryIt, List<D> output, int numSuffixes) {
        for (int j = 0; j < numSuffixes; ++j) {
            DefaultQuery<I, D> qry = queryIt.next();
            output.add(qry.getOutput());
        }
    }

    protected boolean processContents(RowImpl<I> row, List<D> rowContents, boolean makeCanonical) {
        boolean added = false;
        Integer contentId = this.rowContentIds.get(rowContents);
        if (contentId == NO_ENTRY) {
            contentId = this.numberOfDistinctRows();
            this.rowContentIds.put(rowContents, contentId);
            this.allRowContents.add(rowContents);
            added = true;
            if (makeCanonical) {
                this.canonicalRows.add(row);
            } else {
                this.canonicalRows.add(null);
            }
        }
        row.setRowContentId(contentId);
        return added;
    }

    @Override
    public int numberOfDistinctRows() {
        return this.allRowContents.size();
    }

    @Override
    public List<List<Row<I>>> addSuffix(Word<I> suffix, MembershipOracle<I, D> oracle) {
        return this.addSuffixes(Collections.singletonList(suffix), oracle);
    }

    @Override
    public List<List<Row<I>>> addSuffixes(Collection<? extends Word<I>> newSuffixes, MembershipOracle<I, D> oracle) {
        int oldSuffixCount = this.suffixes.size();
        ArrayList<Word<I>> newSuffixList = new ArrayList<Word<I>>();
        for (Word<I> suffix : newSuffixes) {
            if (!this.suffixSet.add(suffix)) continue;
            newSuffixList.add(suffix);
        }
        if (newSuffixList.isEmpty()) {
            return Collections.emptyList();
        }
        int numNewSuffixes = newSuffixList.size();
        int numSpRows = this.shortPrefixRows.size();
        int rowCount = numSpRows + this.longPrefixRows.size();
        ArrayList<DefaultQuery<I, D>> queries = new ArrayList<DefaultQuery<I, D>>(rowCount * numNewSuffixes);
        for (RowImpl<I> rowImpl : this.shortPrefixRows) {
            AbstractObservationTable.buildQueries(queries, rowImpl.getLabel(), newSuffixList);
        }
        for (RowImpl<I> rowImpl : this.longPrefixRows) {
            AbstractObservationTable.buildQueries(queries, rowImpl.getLabel(), newSuffixList);
        }
        oracle.processQueries(queries);
        Iterator<DefaultQuery<I, D>> queryIt = queries.iterator();
        for (RowImpl<I> rowImpl : this.shortPrefixRows) {
            List<D> rowContents = this.allRowContents.get(rowImpl.getRowContentId());
            if (rowContents.size() == oldSuffixCount) {
                this.rowContentIds.remove(rowContents);
                AbstractObservationTable.fetchResults(queryIt, rowContents, numNewSuffixes);
                this.rowContentIds.put(rowContents, rowImpl.getRowContentId());
                continue;
            }
            ArrayList<D> newContents = new ArrayList<D>(oldSuffixCount + numNewSuffixes);
            newContents.addAll(rowContents.subList(0, oldSuffixCount));
            AbstractObservationTable.fetchResults(queryIt, newContents, numNewSuffixes);
            this.processContents(rowImpl, newContents, true);
        }
        ArrayList<List<Row<I>>> arrayList = new ArrayList<List<Row<I>>>();
        numSpRows = this.numberOfDistinctRows();
        for (RowImpl<I> row : this.longPrefixRows) {
            int id;
            List<D> rowContents = this.allRowContents.get(row.getRowContentId());
            if (rowContents.size() == oldSuffixCount) {
                this.rowContentIds.remove(rowContents);
                AbstractObservationTable.fetchResults(queryIt, rowContents, numNewSuffixes);
                this.rowContentIds.put(rowContents, row.getRowContentId());
                continue;
            }
            ArrayList<D> newContents = new ArrayList<D>(oldSuffixCount + numNewSuffixes);
            newContents.addAll(rowContents.subList(0, oldSuffixCount));
            AbstractObservationTable.fetchResults(queryIt, newContents, numNewSuffixes);
            if (this.processContents(row, newContents, false)) {
                arrayList.add(new ArrayList());
            }
            if ((id = row.getRowContentId()) < numSpRows) continue;
            ((List)arrayList.get(id - numSpRows)).add(row);
        }
        this.suffixes.addAll(newSuffixList);
        return arrayList;
    }

    @Override
    public boolean isInitialConsistencyCheckRequired() {
        return this.initialConsistencyCheckRequired;
    }

    @Override
    public List<List<Row<I>>> addShortPrefixes(List<? extends Word<I>> shortPrefixes, MembershipOracle<I, D> oracle) {
        ArrayList toSpRows = new ArrayList();
        for (Word<I> sp : shortPrefixes) {
            RowImpl<I> row = this.rowMap.get(sp);
            if (row != null) {
                if (row.isShortPrefixRow()) {
                    continue;
                }
            } else {
                row = this.createSpRow(sp);
            }
            toSpRows.add(row);
        }
        return this.toShortPrefixes(toSpRows, oracle);
    }

    protected void makeShort(RowImpl<I> row) {
        int cid;
        if (row.isShortPrefixRow()) {
            return;
        }
        int lastIdx = this.longPrefixRows.size() - 1;
        RowImpl<I> last = this.longPrefixRows.get(lastIdx);
        int rowIdx = row.getLpIndex();
        this.longPrefixRows.remove(lastIdx);
        if (last != row) {
            this.longPrefixRows.set(rowIdx, last);
            last.setLpIndex(rowIdx);
        }
        this.shortPrefixRows.add(row);
        row.makeShort(this.alphabet.size());
        if (row.hasContents() && this.canonicalRows.get(cid = row.getRowContentId()) == null) {
            this.canonicalRows.set(cid, row);
        }
    }

    protected static <I, D> void buildRowQueries(List<DefaultQuery<I, D>> queryList, List<? extends Row<I>> rows, List<? extends Word<I>> suffixes) {
        for (Row<I> row : rows) {
            AbstractObservationTable.buildQueries(queryList, row.getLabel(), suffixes);
        }
    }

    @Override
    public List<D> rowContents(Row<I> row) {
        return this.allRowContents.get(row.getRowContentId());
    }

    @Override
    public RowImpl<I> getRow(int rowId) {
        return this.allRows.get(rowId);
    }

    @Override
    public RowImpl<I> getRow(Word<I> prefix) {
        return this.rowMap.get(prefix);
    }

    @Override
    public int numberOfRows() {
        return this.shortPrefixRows.size() + this.longPrefixRows.size();
    }

    @Override
    public List<Word<I>> getSuffixes() {
        return this.suffixes;
    }

    @Override
    public boolean isInitialized() {
        return !this.allRows.isEmpty();
    }

    @Override
    public Alphabet<I> getInputAlphabet() {
        return this.alphabet;
    }

    public void setInputAlphabet(Alphabet<I> alphabet) {
        this.alphabet = alphabet;
    }

    public Word<I> transformAccessSequence(Word<I> word) {
        Row current = this.shortPrefixRows.get(0);
        for (Object sym : word) {
            current = this.getRowSuccessor(current, sym);
            current = this.canonicalRows.get(current.getRowContentId());
        }
        return current.getLabel();
    }

    public boolean isAccessSequence(Word<I> word) {
        Row current = this.shortPrefixRows.get(0);
        for (Object sym : word) {
            if (this.isCanonical(current = this.getRowSuccessor(current, sym))) continue;
            return false;
        }
        return true;
    }

    private boolean isCanonical(Row<I> row) {
        if (!row.isShortPrefixRow()) {
            return false;
        }
        int contentId = row.getRowContentId();
        return this.canonicalRows.get(contentId) == row;
    }

    @Override
    @Nonnull
    public List<Row<I>> getShortPrefixRows() {
        return Collections.unmodifiableList(this.shortPrefixRows);
    }

    @Override
    @Nonnull
    public Collection<Row<I>> getLongPrefixRows() {
        return Collections.unmodifiableList(this.longPrefixRows);
    }
}

