/*
 * Decompiled with CFR 0.152.
 */
package de.learnlib.datastructure.observationtable.writer;

import de.learnlib.datastructure.observationtable.ObservationTable;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.WillNotClose;
import net.automatalib.commons.util.IOUtil;

@ParametersAreNonnullByDefault
public interface ObservationTableWriter<I, D> {
    public void write(ObservationTable<? extends I, ? extends D> var1, @WillNotClose Appendable var2) throws IOException;

    default public void write(ObservationTable<? extends I, ? extends D> table, @WillNotClose PrintStream out) {
        try {
            this.write(table, (Appendable)out);
        }
        catch (IOException ex) {
            throw new AssertionError((Object)"Writing to PrintStream must not throw");
        }
    }

    default public void write(ObservationTable<? extends I, ? extends D> table, @WillNotClose StringBuilder out) {
        try {
            this.write(table, (Appendable)out);
        }
        catch (IOException ex) {
            throw new AssertionError((Object)"Writing to StringBuilder must not throw");
        }
    }

    default public void write(ObservationTable<? extends I, ? extends D> table, File file) throws IOException {
        try (BufferedWriter bw = new BufferedWriter(IOUtil.asUTF8Writer((File)file));){
            this.write(table, bw);
        }
    }
}

