/*
 * Decompiled with CFR 0.152.
 */
package de.learnlib.datastructure.observationtable;

import de.learnlib.datastructure.observationtable.Row;
import java.io.Serializable;
import net.automatalib.commons.util.array.ResizingObjectArray;
import net.automatalib.words.Word;

final class RowImpl<I>
implements Row<I>,
Serializable {
    private final Word<I> label;
    private final int rowId;
    private int rowContentId = -1;
    private int lpIndex;
    private ResizingObjectArray successors;

    RowImpl(Word<I> label, int rowId, int alphabetSize) {
        this(label, rowId);
        this.makeShort(alphabetSize);
    }

    RowImpl(Word<I> label, int rowId) {
        this.label = label;
        this.rowId = rowId;
    }

    void makeShort(int initialAlphabetSize) {
        if (this.lpIndex == -1) {
            return;
        }
        this.lpIndex = -1;
        this.successors = new ResizingObjectArray(initialAlphabetSize);
    }

    @Override
    public RowImpl<I> getSuccessor(int inputIdx) {
        return (RowImpl)this.successors.array[inputIdx];
    }

    void setSuccessor(int inputIdx, Row<I> succ) {
        this.successors.array[inputIdx] = succ;
    }

    @Override
    public Word<I> getLabel() {
        return this.label;
    }

    @Override
    public int getRowId() {
        return this.rowId;
    }

    @Override
    public int getRowContentId() {
        return this.rowContentId;
    }

    void setRowContentId(int id) {
        this.rowContentId = id;
    }

    @Override
    public boolean isShortPrefixRow() {
        return this.lpIndex == -1;
    }

    boolean hasContents() {
        return this.rowContentId != -1;
    }

    int getLpIndex() {
        return this.lpIndex;
    }

    void setLpIndex(int lpIndex) {
        this.lpIndex = lpIndex;
    }

    boolean ensureInputCapacity(int capacity) {
        return this.successors.ensureCapacity(capacity);
    }
}

