/*
 * Decompiled with CFR 0.152.
 */
package de.learnlib.datastructure.discriminationtree.model;

import com.google.common.collect.Iterables;
import de.learnlib.api.oracle.MembershipOracle;
import de.learnlib.datastructure.discriminationtree.model.AbstractDTNode;
import de.learnlib.datastructure.discriminationtree.model.LCAInfo;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import net.automatalib.graphs.Graph;
import net.automatalib.graphs.IndefiniteGraph;
import net.automatalib.util.graphs.traversal.GraphTraversal;
import net.automatalib.visualization.DefaultVisualizationHelper;
import net.automatalib.visualization.VisualizationHelper;
import net.automatalib.words.Word;

public abstract class AbstractDiscriminationTree<DSCR, I, O, D, N extends AbstractDTNode<DSCR, O, D, N>>
implements Graph<N, Map.Entry<O, N>>,
Serializable {
    protected final N root;
    protected transient MembershipOracle<I, O> oracle;

    public AbstractDiscriminationTree(N root, MembershipOracle<I, O> oracle) {
        this.root = root;
        this.oracle = oracle;
    }

    public N sift(Word<I> prefix) {
        return this.sift(this.root, prefix);
    }

    public abstract N sift(N var1, Word<I> var2);

    public N getRoot() {
        return this.root;
    }

    public N leastCommonAncestor(N a, N b) {
        N higher;
        N lower;
        if (((AbstractDTNode)a).getDepth() > ((AbstractDTNode)b).getDepth()) {
            lower = a;
            higher = b;
        } else {
            lower = b;
            higher = a;
        }
        while (((AbstractDTNode)lower).getDepth() > ((AbstractDTNode)higher).getDepth()) {
            lower = ((AbstractDTNode)lower).getParent();
        }
        while (lower != higher) {
            lower = ((AbstractDTNode)lower).getParent();
            higher = ((AbstractDTNode)higher).getParent();
        }
        return lower;
    }

    public LCAInfo<O, N> lcaInfo(N node1, N node2) {
        N curr2;
        N curr1;
        int d1 = ((AbstractDTNode)node1).depth;
        int d2 = ((AbstractDTNode)node2).depth;
        int ddiff = d2 - d1;
        boolean swap = false;
        if (ddiff >= 0) {
            curr1 = node1;
            curr2 = node2;
        } else {
            curr1 = node2;
            curr2 = node1;
            ddiff *= -1;
            swap = true;
        }
        Object out1 = null;
        Object out2 = null;
        while (ddiff > 0) {
            out2 = ((AbstractDTNode)curr2).parentOutcome;
            curr2 = ((AbstractDTNode)curr2).parent;
            --ddiff;
        }
        if (curr1 == curr2) {
            return new LCAInfo<Object, N>(curr1, out1, out2, swap);
        }
        while (curr1 != curr2) {
            out1 = ((AbstractDTNode)curr1).parentOutcome;
            curr1 = ((AbstractDTNode)curr1).parent;
            out2 = ((AbstractDTNode)curr2).parentOutcome;
            curr2 = ((AbstractDTNode)curr2).parent;
        }
        return new LCAInfo<Object, N>(curr1, out1, out2, swap);
    }

    public Collection<N> getNodes() {
        ArrayList nodes = new ArrayList();
        Iterables.addAll(nodes, (Iterable)GraphTraversal.breadthFirstOrder((IndefiniteGraph)this, Collections.singleton(this.root)));
        return nodes;
    }

    public Collection<Map.Entry<O, N>> getOutgoingEdges(N node) {
        if (((AbstractDTNode)node).isLeaf()) {
            return Collections.emptySet();
        }
        return ((AbstractDTNode)node).getChildEntries();
    }

    public N getTarget(Map.Entry<O, N> edge) {
        return (N)((AbstractDTNode)edge.getValue());
    }

    public VisualizationHelper<N, Map.Entry<O, N>> getVisualizationHelper() {
        return new DefaultVisualizationHelper<N, Map.Entry<O, N>>(){

            public boolean getNodeProperties(N node, Map<String, String> properties) {
                if (!super.getNodeProperties(node, properties)) {
                    return false;
                }
                if (((AbstractDTNode)node).isLeaf()) {
                    properties.put("shape", "box");
                    properties.put("label", String.valueOf(((AbstractDTNode)node).getData()));
                } else {
                    Object d = ((AbstractDTNode)node).getDiscriminator();
                    properties.put("shape", "oval");
                    properties.put("label", d.toString());
                }
                return true;
            }

            public boolean getEdgeProperties(N src, Map.Entry<O, N> edge, N tgt, Map<String, String> properties) {
                if (!super.getEdgeProperties(src, edge, tgt, properties)) {
                    return false;
                }
                properties.put("label", String.valueOf(edge.getKey()));
                return true;
            }
        };
    }

    public void setOracle(MembershipOracle<I, O> oracle) {
        this.oracle = oracle;
    }
}

