/*
 * Decompiled with CFR 0.152.
 */
package de.learnlib.datastructure.discriminationtree.model;

import java.io.Serializable;
import java.util.Collection;
import java.util.Map;
import java.util.Objects;

public abstract class AbstractDTNode<DSCR, O, D, N extends AbstractDTNode<DSCR, O, D, N>>
implements Serializable {
    protected final N parent;
    protected final O parentOutcome;
    protected final int depth;
    protected Map<O, N> children;
    protected DSCR discriminator;
    protected D data;

    public AbstractDTNode(D data) {
        this(null, null, data);
    }

    protected AbstractDTNode(N parent, O parentOutcome, D data) {
        this.parent = parent;
        this.parentOutcome = parentOutcome;
        this.depth = parent != null ? ((AbstractDTNode)parent).depth + 1 : 0;
        this.data = data;
    }

    public boolean isRoot() {
        return this.parent == null;
    }

    public N getParent() {
        return this.parent;
    }

    public DSCR getDiscriminator() {
        return this.discriminator;
    }

    public void setDiscriminator(DSCR discriminator) {
        this.discriminator = discriminator;
    }

    public SplitResult split(DSCR discriminator, O oldOut, O newOut) {
        return this.split(discriminator, oldOut, newOut, null);
    }

    public SplitResult split(DSCR discriminator, O oldOut, O newOut, D newData) {
        assert (this.isLeaf());
        assert (!Objects.equals(oldOut, newOut));
        this.children = this.createChildMap();
        N nodeOld = this.addChild(oldOut, this.data);
        N nodeNew = this.addChild(newOut, newData);
        this.data = null;
        this.discriminator = discriminator;
        return new SplitResult(this, nodeOld, nodeNew);
    }

    public boolean isLeaf() {
        return this.children == null;
    }

    protected abstract Map<O, N> createChildMap();

    protected N addChild(O outcome, D data) {
        N child = this.createChild(outcome, data);
        this.children.put(outcome, child);
        return child;
    }

    protected abstract N createChild(O var1, D var2);

    public N child(O out) {
        return this.child(out, null);
    }

    public N child(O out, D defaultData) {
        assert (!this.isLeaf());
        N result = this.getChild(out);
        if (result == null) {
            result = this.addChild(out, defaultData);
        }
        return result;
    }

    public N getChild(O out) {
        return (N)((AbstractDTNode)this.children.get(out));
    }

    public Collection<N> getChildren() {
        return this.children.values();
    }

    public Collection<Map.Entry<O, N>> getChildEntries() {
        return this.children.entrySet();
    }

    public void replaceChildren(Map<O, N> repChildren) {
        this.children = repChildren;
    }

    public int getDepth() {
        return this.depth;
    }

    public D getData() {
        assert (this.isLeaf());
        return this.data;
    }

    public void setData(D data) {
        assert (this.isLeaf());
        this.data = data;
    }

    public O subtreeLabel(N descendant) {
        N curr = descendant;
        while (((AbstractDTNode)curr).depth > this.depth + 1) {
            curr = ((AbstractDTNode)curr).parent;
        }
        if (((AbstractDTNode)curr).parent != this) {
            return null;
        }
        return ((AbstractDTNode)curr).getParentOutcome();
    }

    public O getParentOutcome() {
        return this.parentOutcome;
    }

    public static class SplitResult {
        public final N nodeOld;
        public final N nodeNew;
        final /* synthetic */ AbstractDTNode this$0;

        public SplitResult(N nodeOld, N nodeNew) {
            this.this$0 = this$0;
            this.nodeOld = nodeOld;
            this.nodeNew = nodeNew;
        }
    }
}

