/*
 * Decompiled with CFR 0.152.
 */
package de.learnlib.datastructure.discriminationtree.iterators;

import com.google.common.collect.AbstractIterator;
import de.learnlib.datastructure.discriminationtree.model.AbstractDTNode;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.function.Function;

public class TransformingLeavesIterator<N extends AbstractDTNode<?, ?, ?, N>, D>
extends AbstractIterator<D> {
    private final Deque<N> stack = new ArrayDeque<N>();
    private final Function<N, D> extractor;

    public TransformingLeavesIterator(N root, Function<N, D> extractor) {
        this.stack.push(root);
        this.extractor = extractor;
    }

    protected D computeNext() {
        while (!this.stack.isEmpty()) {
            AbstractDTNode curr = (AbstractDTNode)this.stack.pop();
            if (curr.isLeaf()) {
                D value = this.extractor.apply(curr);
                if (value == null) continue;
                return value;
            }
            for (AbstractDTNode child : curr.getChildren()) {
                this.stack.push(child);
            }
        }
        return (D)this.endOfData();
    }
}

