/*
 * Decompiled with CFR 0.152.
 */
package de.learnlib.counterexample;

import de.learnlib.AccessSequenceTransformer;
import de.learnlib.counterexample.GlobalSuffixFinder;
import de.learnlib.counterexample.LocalSuffixFinder;
import de.learnlib.counterexample.LocalSuffixFinders;
import de.learnlib.oracle.MembershipOracle;
import de.learnlib.query.Query;
import java.util.Collections;
import java.util.List;
import net.automatalib.automaton.concept.SuffixOutput;
import net.automatalib.word.Word;
import org.checkerframework.checker.nullness.qual.Nullable;

public final class GlobalSuffixFinders {
    public static final GlobalSuffixFinder<@Nullable Object, @Nullable Object> MALER_PNUELI = new GlobalSuffixFinder<Object, Object>(){

        @Override
        public <RI, RD> List<Word<RI>> findSuffixes(Query<RI, RD> ceQuery, AccessSequenceTransformer<RI> asTransformer, SuffixOutput<RI, RD> hypOutput, MembershipOracle<RI, RD> oracle) {
            return GlobalSuffixFinders.findMalerPnueli(ceQuery);
        }

        public String toString() {
            return "MalerPnueli";
        }
    };
    public static final GlobalSuffixFinder<@Nullable Object, @Nullable Object> SHAHBAZ = new GlobalSuffixFinder<Object, Object>(){

        @Override
        public <RI, RD> List<Word<RI>> findSuffixes(Query<RI, RD> ceQuery, AccessSequenceTransformer<RI> asTransformer, SuffixOutput<RI, RD> hypOutput, MembershipOracle<RI, RD> oracle) {
            return GlobalSuffixFinders.findShahbaz(ceQuery, asTransformer);
        }

        public String toString() {
            return "Shahbaz";
        }
    };
    public static final GlobalSuffixFinder<@Nullable Object, @Nullable Object> FIND_LINEAR = GlobalSuffixFinders.fromLocalFinder(LocalSuffixFinders.FIND_LINEAR, false);
    public static final GlobalSuffixFinder<@Nullable Object, @Nullable Object> FIND_LINEAR_ALLSUFFIXES = GlobalSuffixFinders.fromLocalFinder(LocalSuffixFinders.FIND_LINEAR, true);
    public static final GlobalSuffixFinder<@Nullable Object, @Nullable Object> FIND_LINEAR_REVERSE = GlobalSuffixFinders.fromLocalFinder(LocalSuffixFinders.FIND_LINEAR_REVERSE, false);
    public static final GlobalSuffixFinder<@Nullable Object, @Nullable Object> FIND_LINEAR_REVERSE_ALLSUFFIXES = GlobalSuffixFinders.fromLocalFinder(LocalSuffixFinders.FIND_LINEAR_REVERSE, true);
    public static final GlobalSuffixFinder<@Nullable Object, @Nullable Object> RIVEST_SCHAPIRE = GlobalSuffixFinders.fromLocalFinder(LocalSuffixFinders.RIVEST_SCHAPIRE, false);
    public static final GlobalSuffixFinder<@Nullable Object, @Nullable Object> RIVEST_SCHAPIRE_ALLSUFFIXES = GlobalSuffixFinders.fromLocalFinder(LocalSuffixFinders.RIVEST_SCHAPIRE, true);

    private GlobalSuffixFinders() {
    }

    public static <I, D> GlobalSuffixFinder<I, D> fromLocalFinder(LocalSuffixFinder<I, D> localFinder) {
        return GlobalSuffixFinders.fromLocalFinder(localFinder, false);
    }

    public static <I, D> GlobalSuffixFinder<I, D> fromLocalFinder(final LocalSuffixFinder<I, D> localFinder, final boolean allSuffixes) {
        return new GlobalSuffixFinder<I, D>(){

            @Override
            public <RI extends I, RD extends D> List<Word<RI>> findSuffixes(Query<RI, RD> ceQuery, AccessSequenceTransformer<RI> asTransformer, SuffixOutput<RI, RD> hypOutput, MembershipOracle<RI, RD> oracle) {
                int idx = localFinder.findSuffixIndex(ceQuery, asTransformer, hypOutput, oracle);
                return GlobalSuffixFinders.suffixesForLocalOutput(ceQuery, idx, allSuffixes);
            }

            public String toString() {
                return localFinder.toString() + (allSuffixes ? "-AllSuffixes" : "");
            }
        };
    }

    public static <I, D> List<Word<I>> suffixesForLocalOutput(Query<I, D> ceQuery, int localSuffixIdx) {
        return GlobalSuffixFinders.suffixesForLocalOutput(ceQuery, localSuffixIdx, false);
    }

    public static <I, D> List<Word<I>> suffixesForLocalOutput(Query<I, D> ceQuery, int localSuffixIdx, boolean allSuffixes) {
        if (localSuffixIdx == -1) {
            return Collections.emptyList();
        }
        Word suffix = ceQuery.getInput().subWord(localSuffixIdx);
        if (!allSuffixes) {
            return Collections.singletonList(suffix);
        }
        return suffix.suffixes(false);
    }

    public static <I, D> List<Word<I>> findMalerPnueli(Query<I, D> ceQuery) {
        return ceQuery.getInput().suffixes(false);
    }

    public static <I, D> List<Word<I>> findShahbaz(Query<I, D> ceQuery, AccessSequenceTransformer<I> asTransformer) {
        Word nextPrefix;
        int i;
        Word queryWord = ceQuery.getInput();
        int queryLen = queryWord.length();
        Word prefix = ceQuery.getPrefix();
        for (i = prefix.length(); i <= queryLen && asTransformer.isAccessSequence(nextPrefix = queryWord.prefix(i)); ++i) {
        }
        return queryWord.subWord(i).suffixes(false);
    }

    public static <I, D> List<Word<I>> findLinear(Query<I, D> ceQuery, AccessSequenceTransformer<I> asTransformer, SuffixOutput<I, D> hypOutput, MembershipOracle<I, D> oracle, boolean allSuffixes) {
        int idx = LocalSuffixFinders.findLinear(ceQuery, asTransformer, hypOutput, oracle);
        return GlobalSuffixFinders.suffixesForLocalOutput(ceQuery, idx, allSuffixes);
    }

    public static <I, D> List<Word<I>> findLinearReverse(Query<I, D> ceQuery, AccessSequenceTransformer<I> asTransformer, SuffixOutput<I, D> hypOutput, MembershipOracle<I, D> oracle, boolean allSuffixes) {
        int idx = LocalSuffixFinders.findLinearReverse(ceQuery, asTransformer, hypOutput, oracle);
        return GlobalSuffixFinders.suffixesForLocalOutput(ceQuery, idx, allSuffixes);
    }

    public static <I, D> List<Word<I>> findRivestSchapire(Query<I, D> ceQuery, AccessSequenceTransformer<I> asTransformer, SuffixOutput<I, D> hypOutput, MembershipOracle<I, D> oracle, boolean allSuffixes) {
        int idx = LocalSuffixFinders.findRivestSchapire(ceQuery, asTransformer, hypOutput, oracle);
        return GlobalSuffixFinders.suffixesForLocalOutput(ceQuery, idx, allSuffixes);
    }

    public static GlobalSuffixFinder<@Nullable Object, @Nullable Object>[] values() {
        return new GlobalSuffixFinder[]{MALER_PNUELI, SHAHBAZ, FIND_LINEAR, FIND_LINEAR_ALLSUFFIXES, FIND_LINEAR_REVERSE, FIND_LINEAR_REVERSE_ALLSUFFIXES, RIVEST_SCHAPIRE, RIVEST_SCHAPIRE_ALLSUFFIXES};
    }
}

