/*
 * Decompiled with CFR 0.152.
 */
package de.learnlib.counterexamples.acex;

import de.learnlib.acex.impl.AbstractBaseCounterexample;
import de.learnlib.api.oracle.MembershipOracle;
import java.util.Objects;
import java.util.function.Function;
import net.automatalib.words.Word;

public class OutInconsPrefixTransformAcex<I, D>
extends AbstractBaseCounterexample<D> {
    private final Word<I> suffix;
    private final MembershipOracle<I, D> oracle;
    private final Function<Word<I>, Word<I>> asTransform;

    public OutInconsPrefixTransformAcex(Word<I> suffix, MembershipOracle<I, D> oracle, Function<Word<I>, Word<I>> asTransform) {
        this(suffix, suffix.length() + 1, oracle, asTransform);
    }

    protected OutInconsPrefixTransformAcex(Word<I> suffix, int length, MembershipOracle<I, D> oracle, Function<Word<I>, Word<I>> asTransform) {
        super(length);
        this.suffix = suffix;
        this.oracle = oracle;
        this.asTransform = asTransform;
    }

    protected D computeEffect(int index) {
        Word prefix = this.suffix.prefix(index);
        Word suffix = this.suffix.subWord(index);
        Word<I> asPrefix = this.asTransform.apply(prefix);
        return (D)this.oracle.answerQuery(asPrefix, suffix);
    }

    public boolean checkEffects(D eff1, D eff2) {
        return Objects.equals(eff1, eff2);
    }
}

