/*
 * Decompiled with CFR 0.152.
 */
package de.learnlib.counterexamples.acex;

import de.learnlib.acex.impl.AbstractBaseCounterexample;
import de.learnlib.api.oracle.MembershipOracle;
import java.util.Objects;
import java.util.function.Function;
import net.automatalib.automata.concepts.SuffixOutput;
import net.automatalib.words.Word;

public class ClassicPrefixTransformAcex<I, D>
extends AbstractBaseCounterexample<Boolean> {
    private final Word<I> suffix;
    private final MembershipOracle<I, D> oracle;
    private final SuffixOutput<I, D> hypOut;
    private final Function<Word<I>, Word<I>> asTransform;

    public ClassicPrefixTransformAcex(Word<I> suffix, MembershipOracle<I, D> oracle, SuffixOutput<I, D> hypOut, Function<Word<I>, Word<I>> asTransform) {
        this(suffix, suffix.length() + 1, oracle, hypOut, asTransform);
    }

    protected ClassicPrefixTransformAcex(Word<I> suffix, int length, MembershipOracle<I, D> oracle, SuffixOutput<I, D> hypOut, Function<Word<I>, Word<I>> asTransform) {
        super(length);
        this.suffix = suffix;
        this.oracle = oracle;
        this.asTransform = asTransform;
        this.hypOut = hypOut;
    }

    protected Boolean computeEffect(int index) {
        Word prefix = this.suffix.prefix(index);
        Word suffix = this.suffix.subWord(index);
        Word<I> asPrefix = this.asTransform.apply(prefix);
        return Objects.equals(this.hypOut.computeSuffixOutput(asPrefix, (Iterable)suffix), this.oracle.answerQuery(asPrefix, suffix));
    }

    public boolean checkEffects(Boolean eff1, Boolean eff2) {
        return Objects.equals(eff1, eff2);
    }
}

