/*
 * Decompiled with CFR 0.152.
 */
package de.learnlib.counterexamples.prefixtransform;

import com.google.common.base.Objects;
import de.learnlib.acex.impl.BaseAbstractCounterexample;
import de.learnlib.api.AccessSequenceTransformer;
import de.learnlib.api.MembershipOracle;
import de.learnlib.oracles.MQUtil;
import net.automatalib.automata.concepts.SuffixOutput;
import net.automatalib.words.Word;

public class PrefixTransformAcex<I, O>
extends BaseAbstractCounterexample {
    private final Word<I> counterexample;
    private final MembershipOracle<I, O> oracle;
    private final AccessSequenceTransformer<I> asTransformer;
    private final SuffixOutput<I, O> hypothesis;

    public PrefixTransformAcex(Word<I> counterexample, MembershipOracle<I, O> oracle, AccessSequenceTransformer<I> asTransformer, SuffixOutput<I, O> hypothesis) {
        super(counterexample.length());
        this.counterexample = counterexample;
        this.oracle = oracle;
        this.asTransformer = asTransformer;
        this.hypothesis = hypothesis;
    }

    protected int computeEffect(int index) {
        Object oracleOut;
        Word prefix = this.counterexample.prefix(index);
        Word suffix = this.counterexample.subWord(index);
        Word transformedPrefix = this.asTransformer.transformAccessSequence(prefix);
        Object hypOut = this.hypothesis.computeSuffixOutput((Iterable)transformedPrefix, (Iterable)suffix);
        return Objects.equal((Object)hypOut, (Object)(oracleOut = MQUtil.output(this.oracle, (Word)transformedPrefix, (Word)suffix))) ? 1 : 0;
    }

    public int getReductionPotential() {
        Word prefix;
        int pot = 0;
        do {
            prefix = this.counterexample.prefix(++pot);
        } while (pot < this.counterexample.length() && this.asTransformer.isAccessSequence(prefix));
        return pot - 1;
    }
}

