/*
 * Decompiled with CFR 0.152.
 */
package de.learnlib.counterexamples;

import de.learnlib.acex.AcexAnalyzer;
import de.learnlib.api.AccessSequenceTransformer;
import de.learnlib.api.MembershipOracle;
import de.learnlib.api.Query;
import de.learnlib.counterexamples.LocalSuffixFinder;
import de.learnlib.counterexamples.prefixtransform.PrefixTransformAcex;
import net.automatalib.automata.concepts.SuffixOutput;
import net.automatalib.words.Word;

public class AcexLocalSuffixFinder
implements LocalSuffixFinder<Object, Object> {
    private final AcexAnalyzer analyzer;
    private final boolean reduce;
    private final String name;

    public static <RI, RO> int findSuffixIndex(AcexAnalyzer analyzer, boolean reduce, Query<RI, RO> ceQuery, AccessSequenceTransformer<RI> asTransformer, SuffixOutput<RI, RO> hypOutput, MembershipOracle<RI, RO> oracle) {
        Word counterexample = ceQuery.getInput();
        PrefixTransformAcex<RI, RO> acex = new PrefixTransformAcex<RI, RO>(counterexample, oracle, asTransformer, hypOutput);
        int start = 0;
        if (reduce) {
            start = acex.getReductionPotential();
        }
        int idx = analyzer.analyzeAbstractCounterexample(acex, start);
        return idx + 1;
    }

    public AcexLocalSuffixFinder(AcexAnalyzer analyzer, boolean reduce, String name) {
        this.analyzer = analyzer;
        this.reduce = reduce;
        this.name = name;
    }

    @Override
    public <RI, RO> int findSuffixIndex(Query<RI, RO> ceQuery, AccessSequenceTransformer<RI> asTransformer, SuffixOutput<RI, RO> hypOutput, MembershipOracle<RI, RO> oracle) {
        return AcexLocalSuffixFinder.findSuffixIndex(this.analyzer, this.reduce, ceQuery, asTransformer, hypOutput, oracle);
    }

    public String toString() {
        return this.name;
    }
}

