/*
 * Decompiled with CFR 0.152.
 */
package de.learnlib.counterexamples;

import de.learnlib.api.AccessSequenceTransformer;
import de.learnlib.api.MembershipOracle;
import de.learnlib.api.Query;
import de.learnlib.counterexamples.LocalSuffixFinder;
import de.learnlib.oracles.MQUtil;
import java.util.Objects;
import net.automatalib.automata.concepts.SuffixOutput;
import net.automatalib.words.Word;

public abstract class LocalSuffixFinders {
    public static final LocalSuffixFinder<Object, Object> FIND_LINEAR = new LocalSuffixFinder<Object, Object>(){

        @Override
        public <RI, RD> int findSuffixIndex(Query<RI, RD> ceQuery, AccessSequenceTransformer<RI> asTransformer, SuffixOutput<RI, RD> hypOutput, MembershipOracle<RI, RD> oracle) {
            return LocalSuffixFinders.findLinear(ceQuery, asTransformer, hypOutput, oracle);
        }

        public String toString() {
            return "FindLinear";
        }
    };
    public static final LocalSuffixFinder<Object, Object> FIND_LINEAR_REVERSE = new LocalSuffixFinder<Object, Object>(){

        @Override
        public <RI, RD> int findSuffixIndex(Query<RI, RD> ceQuery, AccessSequenceTransformer<RI> asTransformer, SuffixOutput<RI, RD> hypOutput, MembershipOracle<RI, RD> oracle) {
            return LocalSuffixFinders.findLinearReverse(ceQuery, asTransformer, hypOutput, oracle);
        }

        public String toString() {
            return "FindLinear-Reverse";
        }
    };
    public static final LocalSuffixFinder<Object, Object> RIVEST_SCHAPIRE = new LocalSuffixFinder<Object, Object>(){

        @Override
        public <RI, RD> int findSuffixIndex(Query<RI, RD> ceQuery, AccessSequenceTransformer<RI> asTransformer, SuffixOutput<RI, RD> hypOutput, MembershipOracle<RI, RD> oracle) {
            return LocalSuffixFinders.findRivestSchapire(ceQuery, asTransformer, hypOutput, oracle);
        }

        public String toString() {
            return "RivestSchapire";
        }
    };

    public static <S, I, D> int findLinear(Query<I, D> ceQuery, AccessSequenceTransformer<I> asTransformer, SuffixOutput<I, D> hypOutput, MembershipOracle<I, D> oracle) {
        int min;
        Word queryWord = ceQuery.getInput();
        int queryLen = queryWord.length();
        Word prefix = ceQuery.getPrefix();
        int prefixLen = prefix.length();
        for (int i = min = asTransformer.isAccessSequence(prefix) ? prefixLen + 1 : prefixLen; i <= queryLen; ++i) {
            Object mqOut;
            Word nextSuffix;
            Word nextPrefix = queryWord.prefix(i);
            Word as = asTransformer.transformAccessSequence(nextPrefix);
            Object hypOut = hypOutput.computeSuffixOutput((Iterable)as, (Iterable)(nextSuffix = queryWord.subWord(i)));
            if (!Objects.equals(hypOut, mqOut = MQUtil.output(oracle, (Word)as, (Word)nextSuffix))) continue;
            return i;
        }
        return -1;
    }

    public static <I, D> int findLinearReverse(Query<I, D> ceQuery, AccessSequenceTransformer<I> asTransformer, SuffixOutput<I, D> hypOutput, MembershipOracle<I, D> oracle) {
        Word queryWord = ceQuery.getInput();
        int queryLen = queryWord.length();
        Word prefix = ceQuery.getPrefix();
        int prefixLen = prefix.length();
        int min = asTransformer.isAccessSequence(prefix) ? prefixLen : prefixLen - 1;
        for (int i = queryLen - 1; i >= min; --i) {
            Object mqOut;
            Word nextSuffix;
            Word nextPrefix = queryWord.prefix(i);
            Word as = asTransformer.transformAccessSequence(nextPrefix);
            Object hypOut = hypOutput.computeSuffixOutput((Iterable)as, (Iterable)(nextSuffix = queryWord.subWord(i)));
            if (Objects.equals(hypOut, mqOut = MQUtil.output(oracle, (Word)as, (Word)nextSuffix))) continue;
            return i + 1;
        }
        return -1;
    }

    public static <I, D> int findRivestSchapire(Query<I, D> ceQuery, AccessSequenceTransformer<I> asTransformer, SuffixOutput<I, D> hypOutput, MembershipOracle<I, D> oracle) {
        Word queryWord = ceQuery.getInput();
        int queryLen = queryWord.length();
        Word prefix = ceQuery.getPrefix();
        int prefixLen = prefix.length();
        int low = asTransformer.isAccessSequence(prefix) ? prefixLen : prefixLen - 1;
        int high = queryLen;
        while (high - low > 1) {
            Object ceOut;
            Word nextSuffix;
            int mid = low + (high - low + 1) / 2;
            Word nextPrefix = queryWord.prefix(mid);
            Word as = asTransformer.transformAccessSequence(nextPrefix);
            Object hypOut = hypOutput.computeSuffixOutput((Iterable)as, (Iterable)(nextSuffix = queryWord.subWord(mid)));
            if (!Objects.equals(hypOut, ceOut = MQUtil.output(oracle, (Word)as, (Word)nextSuffix))) {
                low = mid;
                continue;
            }
            high = mid;
        }
        return low + 1;
    }

    public static LocalSuffixFinder<Object, Object>[] values() {
        return new LocalSuffixFinder[]{FIND_LINEAR, FIND_LINEAR_REVERSE, RIVEST_SCHAPIRE};
    }

    private LocalSuffixFinders() {
    }
}

