/*
 * Decompiled with CFR 0.152.
 */
package de.learnlib.mealy;

import de.learnlib.api.MembershipOracle;
import de.learnlib.api.Query;
import java.util.ArrayList;
import java.util.Collection;
import net.automatalib.words.Word;

final class SymbolOracleWrapper<I, O>
implements MembershipOracle<I, O> {
    private final MembershipOracle<I, Word<O>> wordOracle;

    public SymbolOracleWrapper(MembershipOracle<I, Word<O>> wordOracle) {
        this.wordOracle = wordOracle;
    }

    @Override
    public void processQueries(Collection<? extends Query<I, O>> queries) {
        ArrayList<LastSymbolQuery<I, O>> lsQueries = new ArrayList<LastSymbolQuery<I, O>>(queries.size());
        for (Query<I, O> qry : queries) {
            lsQueries.add(new LastSymbolQuery<I, O>(qry));
        }
        this.wordOracle.processQueries(lsQueries);
    }

    private static final class LastSymbolQuery<I, O>
    extends Query<I, Word<O>> {
        private final Query<I, O> originalQuery;

        public LastSymbolQuery(Query<I, O> originalQuery) {
            this.originalQuery = originalQuery;
        }

        @Override
        public Word<I> getPrefix() {
            return this.originalQuery.getPrefix();
        }

        @Override
        public Word<I> getSuffix() {
            return this.originalQuery.getSuffix();
        }

        @Override
        public void answer(Word<O> output) {
            this.originalQuery.answer(output.isEmpty() ? null : output.lastSymbol());
        }
    }
}

