/*
 * Decompiled with CFR 0.152.
 */
package de.learnlib.mealy;

import de.learnlib.api.LearningAlgorithm;
import de.learnlib.api.MembershipOracle;
import de.learnlib.mealy.MealyLearnerWrapper;
import de.learnlib.mealy.SymbolOracleWrapper;
import de.learnlib.oracles.DefaultQuery;
import java.util.Objects;
import net.automatalib.automata.transout.MealyMachine;
import net.automatalib.words.Word;

public abstract class MealyUtil {
    public static final int NO_MISMATCH = -1;

    public static <O> int findMismatch(Word<O> out1, Word<O> out2) {
        int len = out1.length();
        assert (len == out2.length());
        for (int i = 0; i < len; ++i) {
            Object sym2;
            Object sym1 = out1.getSymbol(i);
            if (Objects.equals(sym1, sym2 = out2.getSymbol(i))) continue;
            return i;
        }
        return -1;
    }

    public static <I, O> DefaultQuery<I, Word<O>> shortenCounterExample(MealyMachine<?, I, ?, O> hypothesis, DefaultQuery<I, Word<O>> ceQuery) {
        Word cePrefix = ceQuery.getPrefix();
        Word ceSuffix = ceQuery.getSuffix();
        Word hypOut = (Word)hypothesis.computeSuffixOutput(cePrefix, ceSuffix);
        Word<O> ceOut = ceQuery.getOutput();
        assert (ceOut.length() == hypOut.length());
        int mismatchIdx = MealyUtil.findMismatch(hypOut, ceOut);
        if (mismatchIdx == -1) {
            return null;
        }
        return new DefaultQuery(cePrefix, ceSuffix.prefix(mismatchIdx + 1), ceOut.prefix(mismatchIdx + 1));
    }

    public static <I, O> DefaultQuery<I, O> reduceCounterExample(MealyMachine<?, I, ?, O> hypothesis, DefaultQuery<I, Word<O>> ceQuery) {
        Word cePrefix = ceQuery.getPrefix();
        Word ceSuffix = ceQuery.getSuffix();
        Word hypOut = (Word)hypothesis.computeSuffixOutput(cePrefix, ceSuffix);
        Word<O> ceOut = ceQuery.getOutput();
        assert (ceOut.length() == hypOut.length());
        int mismatchIdx = MealyUtil.findMismatch(hypOut, ceOut);
        if (mismatchIdx == -1) {
            return null;
        }
        return new DefaultQuery(cePrefix, ceSuffix.prefix(mismatchIdx + 1), ceOut.getSymbol(mismatchIdx));
    }

    public static <M extends MealyMachine<?, I, ?, O>, I, O> LearningAlgorithm<M, I, Word<O>> wrapSymbolLearner(LearningAlgorithm<M, I, O> learner) {
        return new MealyLearnerWrapper<M, I, O>(learner);
    }

    public static <I, O> MembershipOracle<I, O> wrapWordOracle(MembershipOracle<I, Word<O>> oracle) {
        return new SymbolOracleWrapper<I, O>(oracle);
    }

    private MealyUtil() {
    }
}

