/*
 * Decompiled with CFR 0.152.
 */
package de.learnlib.experiments;

import de.learnlib.api.EquivalenceOracle;
import de.learnlib.api.LearningAlgorithm;
import de.learnlib.logging.LearnLogger;
import de.learnlib.oracles.DefaultQuery;
import de.learnlib.statistics.Counter;
import de.learnlib.statistics.SimpleProfiler;
import java.util.Collection;
import net.automatalib.words.Alphabet;

public class Experiment<A> {
    private static LearnLogger logger = LearnLogger.getLogger(Experiment.class);
    private boolean logModels = false;
    private boolean profile = false;
    private Counter rounds = new Counter("rounds", "#");
    private A finalHypothesis = null;
    private final ExperimentImpl<?, ?> impl;

    public <I, O> Experiment(LearningAlgorithm<? extends A, I, O> learningAlgorithm, EquivalenceOracle<? super A, I, O> equivalenceAlgorithm, Alphabet<I> inputs) {
        this.impl = new ExperimentImpl<I, O>(learningAlgorithm, equivalenceAlgorithm, inputs);
    }

    public A run() {
        this.finalHypothesis = this.impl.run();
        return this.finalHypothesis;
    }

    public A getFinalHypothesis() {
        return this.finalHypothesis;
    }

    private void profileStart(String taskname) {
        if (this.profile) {
            SimpleProfiler.start(taskname);
        }
    }

    private void profileStop(String taskname) {
        if (this.profile) {
            SimpleProfiler.stop(taskname);
        }
    }

    public void setLogModels(boolean logModels) {
        this.logModels = logModels;
    }

    public void setProfile(boolean profile) {
        this.profile = profile;
    }

    public Counter getRounds() {
        return this.rounds;
    }

    private final class ExperimentImpl<I, O> {
        private final LearningAlgorithm<? extends A, I, O> learningAlgorithm;
        private final EquivalenceOracle<? super A, I, O> equivalenceAlgorithm;
        private final Alphabet<I> inputs;

        public ExperimentImpl(LearningAlgorithm<? extends A, I, O> learningAlgorithm, EquivalenceOracle<? super A, I, O> equivalenceAlgorithm, Alphabet<I> inputs) {
            this.learningAlgorithm = learningAlgorithm;
            this.equivalenceAlgorithm = equivalenceAlgorithm;
            this.inputs = inputs;
        }

        public A run() {
            Experiment.this.rounds.increment();
            logger.logPhase("Starting round " + Experiment.this.rounds.getCount());
            logger.logPhase("Learning");
            Experiment.this.profileStart("Learning");
            this.learningAlgorithm.startLearning();
            Experiment.this.profileStop("Learning");
            boolean done = false;
            Object hyp = null;
            while (!done) {
                hyp = this.learningAlgorithm.getHypothesisModel();
                if (Experiment.this.logModels) {
                    logger.logModel(hyp);
                }
                logger.logPhase("Searching for counterexample");
                Experiment.this.profileStart("Searching for counterexample");
                DefaultQuery<I, O> ce = this.equivalenceAlgorithm.findCounterExample(hyp, (Collection<I>)this.inputs);
                if (ce == null) {
                    done = true;
                    continue;
                }
                Experiment.this.profileStop("Searching for counterexample");
                logger.logCounterexample(ce.getInput().toString());
                Experiment.this.rounds.increment();
                logger.logPhase("Starting round " + Experiment.this.rounds.getCount());
                logger.logPhase("Learning");
                Experiment.this.profileStart("Learning");
                this.learningAlgorithm.refineHypothesis(ce);
                Experiment.this.profileStop("Learning");
            }
            return hyp;
        }
    }
}

