/*
 * Decompiled with CFR 0.152.
 */
package de.learnlib.cache.sul;

import de.learnlib.api.SUL;
import de.learnlib.cache.mealy.MealyCacheConsistencyTest;
import net.automatalib.incremental.mealy.IncrementalMealyBuilder;
import net.automatalib.incremental.mealy.State;
import net.automatalib.incremental.mealy.TransitionRecord;
import net.automatalib.words.Alphabet;
import net.automatalib.words.WordBuilder;

public class SULCache<I, O>
implements SUL<I, O> {
    private final IncrementalMealyBuilder<I, O> incMealy;
    private final SUL<I, O> delegate;
    private State current;
    private final WordBuilder<I> inputWord = new WordBuilder();
    private WordBuilder<O> outputWord;

    public SULCache(Alphabet<I> alphabet, SUL<I, O> sul) {
        this.incMealy = new IncrementalMealyBuilder(alphabet);
        this.delegate = sul;
    }

    public void reset() {
        if (this.outputWord != null) {
            this.incMealy.insert(this.inputWord.toWord(), this.outputWord.toWord());
        }
        this.inputWord.clear();
        this.outputWord = null;
        this.current = this.incMealy.getInitialState();
    }

    public O step(I in) {
        Object out = null;
        if (this.current != null) {
            TransitionRecord trans = this.incMealy.getTransition(this.current, in);
            if (trans != null) {
                out = this.incMealy.getTransitionOutput(trans);
                this.current = this.incMealy.getSuccessor(trans);
                assert (this.current != null);
            } else {
                this.current = null;
                this.outputWord = new WordBuilder();
                this.delegate.reset();
                for (Object prevSym : this.inputWord) {
                    this.outputWord.append(this.delegate.step(prevSym));
                }
            }
        }
        this.inputWord.append(in);
        if (this.current == null) {
            out = this.delegate.step(in);
            this.outputWord.add(out);
        }
        return (O)out;
    }

    public MealyCacheConsistencyTest<I, O> createCacheConsistencyTest() {
        return new MealyCacheConsistencyTest<I, O>(this.incMealy);
    }
}

