/*
 * Decompiled with CFR 0.152.
 */
package de.learnlib.cache.dfa;

import de.learnlib.api.MembershipOracle;
import de.learnlib.api.Query;
import de.learnlib.cache.dfa.DFACacheConsistencyTest;
import de.learnlib.cache.dfa.ProxyQuery;
import java.util.ArrayList;
import java.util.Collection;
import net.automatalib.incremental.dfa.Acceptance;
import net.automatalib.incremental.dfa.IncrementalDFABuilder;
import net.automatalib.words.Alphabet;

public class DFACacheOracle<I>
implements MembershipOracle.DFAMembershipOracle<I> {
    private final IncrementalDFABuilder<I> incDfa;
    private final MembershipOracle<I, Boolean> delegate;

    public DFACacheOracle(Alphabet<I> alphabet, MembershipOracle<I, Boolean> delegate) {
        this.incDfa = new IncrementalDFABuilder(alphabet);
        this.delegate = delegate;
    }

    public int getCacheSize() {
        return this.incDfa.size();
    }

    public DFACacheConsistencyTest<I> createCacheConsistencyTest() {
        return new DFACacheConsistencyTest<I>(this.incDfa);
    }

    public void processQueries(Collection<? extends Query<I, Boolean>> queries) {
        ArrayList<ProxyQuery<I>> unanswered = new ArrayList<ProxyQuery<I>>();
        for (Query<I, Boolean> query : queries) {
            Acceptance acc = this.incDfa.lookup(query.getInput());
            if (acc != Acceptance.DONT_KNOW) {
                query.answer((Object)(acc == Acceptance.TRUE ? 1 : 0));
                continue;
            }
            unanswered.add(new ProxyQuery<I>(query));
        }
        this.delegate.processQueries(unanswered);
        for (ProxyQuery proxyQuery : unanswered) {
            this.incDfa.insert(proxyQuery.getInput(), proxyQuery.getAnswer().booleanValue());
        }
    }
}

