/*
 * Decompiled with CFR 0.152.
 */
package de.learnlib.cache.mealy;

import de.learnlib.api.MembershipOracle;
import de.learnlib.api.Query;
import de.learnlib.cache.mealy.MasterQuery;
import de.learnlib.cache.mealy.MealyCacheConsistencyTest;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import net.automatalib.commons.util.comparison.CmpUtil;
import net.automatalib.commons.util.mappings.Mapping;
import net.automatalib.incremental.mealy.IncrementalMealyBuilder;
import net.automatalib.words.Alphabet;
import net.automatalib.words.Word;
import net.automatalib.words.WordBuilder;

public class MealyCacheOracle<I, O>
implements MembershipOracle<I, Word<O>> {
    private final MembershipOracle<I, Word<O>> delegate;
    private final IncrementalMealyBuilder<I, O> incMealy;
    private final Comparator<? super Query<I, ?>> queryCmp;
    private final Mapping<? super O, ? extends O> errorSyms;

    public MealyCacheOracle(Alphabet<I> alphabet, MembershipOracle<I, Word<O>> delegate) {
        this(alphabet, null, delegate);
    }

    public MealyCacheOracle(Alphabet<I> alphabet, Mapping<? super O, ? extends O> errorSyms, MembershipOracle<I, Word<O>> delegate) {
        this.delegate = delegate;
        this.incMealy = new IncrementalMealyBuilder(alphabet);
        this.queryCmp = new ReverseLexCmp<I>(alphabet);
        this.errorSyms = errorSyms;
    }

    public int getCacheSize() {
        return this.incMealy.size();
    }

    public MealyCacheConsistencyTest<I, O> createCacheConsistencyTest() {
        return new MealyCacheConsistencyTest<I, O>(this.incMealy);
    }

    public void processQueries(Collection<? extends Query<I, Word<O>>> queries) {
        if (queries.isEmpty()) {
            return;
        }
        ArrayList<Query<I, Word<O>>> qrys = new ArrayList<Query<I, Word<O>>>(queries);
        Collections.sort(qrys, this.queryCmp);
        ArrayList<MasterQuery<I, O>> masterQueries = new ArrayList<MasterQuery<I, O>>();
        Iterator it = qrys.iterator();
        Query q = (Query)it.next();
        Word ref = q.getInput();
        MasterQuery<I, O> master = this.createMasterQuery(ref);
        if (master.getAnswer() == null) {
            masterQueries.add(master);
        }
        master.addSlave(q);
        while (it.hasNext()) {
            q = (Query)it.next();
            Word curr = q.getInput();
            if (!curr.isPrefixOf(ref) && (master = this.createMasterQuery(curr)).getAnswer() == null) {
                masterQueries.add(master);
            }
            master.addSlave(q);
            ref = curr;
        }
        this.delegate.processQueries(masterQueries);
        for (MasterQuery masterQuery : masterQueries) {
            this.postProcess(masterQuery);
        }
    }

    private void postProcess(MasterQuery<I, O> master) {
        Object sym;
        Word<I> word = master.getSuffix();
        Word<O> answer = master.getAnswer();
        if (this.errorSyms == null) {
            this.incMealy.insert(word, answer);
            return;
        }
        int answLen = answer.length();
        int i = 0;
        while (i < answLen && this.errorSyms.get(sym = answer.getSymbol(i++)) == null) {
        }
        if (i == answLen) {
            this.incMealy.insert(word, answer);
        } else {
            this.incMealy.insert(word.prefix(i), answer.prefix(i));
        }
    }

    private MasterQuery<I, O> createMasterQuery(Word<I> word) {
        Object repSym;
        WordBuilder wb = new WordBuilder();
        if (this.incMealy.lookup(word, wb)) {
            return new MasterQuery(word, wb.toWord());
        }
        if (this.errorSyms == null) {
            return new MasterQuery(word);
        }
        int wbSize = wb.size();
        if (wbSize == 0 || (repSym = this.errorSyms.get(wb.getSymbol(wbSize - 1))) == null) {
            return new MasterQuery<I, O>(word, this.errorSyms);
        }
        wb.repeatAppend(word.length() - wbSize, repSym);
        return new MasterQuery(word, wb.toWord());
    }

    private static final class ReverseLexCmp<I>
    implements Comparator<Query<I, ?>> {
        private final Alphabet<I> alphabet;

        public ReverseLexCmp(Alphabet<I> alphabet) {
            this.alphabet = alphabet;
        }

        @Override
        public int compare(Query<I, ?> o1, Query<I, ?> o2) {
            return -CmpUtil.lexCompare((Iterable)o1.getInput(), (Iterable)o2.getInput(), this.alphabet);
        }
    }
}

