/*
 * Decompiled with CFR 0.152.
 */
package de.learnlib.cache.mealy;

import de.learnlib.api.Query;
import java.util.ArrayList;
import java.util.List;
import net.automatalib.commons.util.mappings.Mapping;
import net.automatalib.words.Word;
import net.automatalib.words.WordBuilder;

final class MasterQuery<I, O>
extends Query<I, Word<O>> {
    private final Word<I> word;
    private Word<O> answer;
    private final Mapping<? super O, ? extends O> errorSyms;
    private final List<Query<I, Word<O>>> slaves;

    public MasterQuery(Word<I> word) {
        this(word, (Mapping)null);
    }

    public MasterQuery(Word<I> word, Word<O> output) {
        this.word = word;
        this.answer = output;
        this.errorSyms = null;
        this.slaves = null;
    }

    public MasterQuery(Word<I> word, Mapping<? super O, ? extends O> errorSyms) {
        this.word = word;
        this.errorSyms = errorSyms;
        this.slaves = new ArrayList<Query<I, Word<O>>>();
    }

    public Word<I> getPrefix() {
        return Word.epsilon();
    }

    public Word<I> getSuffix() {
        return this.word;
    }

    public Word<O> getAnswer() {
        return this.answer;
    }

    public void answer(Word<O> output) {
        output = this.truncateOutput(output);
        this.answer = output;
        for (Query<I, Word<O>> slave : this.slaves) {
            this.answerSlave(slave);
        }
    }

    public void addSlave(Query<I, Word<O>> slave) {
        if (this.slaves == null) {
            this.answerSlave(slave);
        } else {
            this.slaves.add(slave);
        }
    }

    private void answerSlave(Query<I, Word<O>> slave) {
        int start = slave.getPrefix().length();
        int end = start + slave.getSuffix().length();
        slave.answer((Object)this.answer.subWord(start, end));
    }

    private Word<O> truncateOutput(Word<O> output) {
        Object sym;
        if (this.errorSyms == null) {
            return output;
        }
        int maxLen = output.length() - 1;
        int i = 0;
        Object repSym = null;
        while (i < maxLen && (repSym = this.errorSyms.get(sym = output.getSymbol(i++))) == null) {
        }
        if (repSym == null) {
            return output;
        }
        WordBuilder wb = new WordBuilder(maxLen + 1);
        wb.append(output.prefix(i));
        wb.repeatAppend(1 + maxLen - i, repSym);
        return wb.toWord();
    }
}

