/*
 * Decompiled with CFR 0.152.
 */
package de.learnlib.filter.cache.sul;

import de.learnlib.filter.cache.mealy.ThreadSafeMealyCacheConsistencyTest;
import de.learnlib.filter.cache.sul.SULCache;
import de.learnlib.oracle.EquivalenceOracle;
import de.learnlib.sul.SUL;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import net.automatalib.incremental.mealy.IncrementalMealyBuilder;
import net.automatalib.ts.output.MealyTransitionSystem;
import net.automatalib.word.WordBuilder;

public class ThreadSafeSULCache<I, O>
extends SULCache<I, O> {
    ThreadSafeSULCache(IncrementalMealyBuilder<I, O> incMealy, SUL<I, O> sul) {
        this(new ThreadSafeSULCacheImpl(incMealy, new ReentrantReadWriteLock(), incMealy.asTransitionSystem(), sul));
    }

    private ThreadSafeSULCache(ThreadSafeSULCacheImpl<?, I, ?, O> cacheImpl) {
        super(cacheImpl);
    }

    private static final class ThreadSafeSULCacheImpl<S, I, T, O>
    extends SULCache.SULCacheImpl<S, I, T, O> {
        private final ReadWriteLock lock;

        ThreadSafeSULCacheImpl(IncrementalMealyBuilder<I, O> incMealy, ReadWriteLock lock, MealyTransitionSystem<S, I, T, O> mealyTs, SUL<I, O> sul) {
            super(incMealy, mealyTs, sul);
            this.lock = lock;
        }

        @Override
        public void pre() {
            this.lock.readLock().lock();
            super.pre();
        }

        @Override
        protected void requiredInitializedDelegate() {
            this.lock.readLock().unlock();
            super.requiredInitializedDelegate();
        }

        @Override
        protected void updateCache(WordBuilder<I> inputBuilder, WordBuilder<O> outputBuilder) {
            if (outputBuilder.isEmpty()) {
                this.lock.readLock().unlock();
            } else {
                this.lock.writeLock().lock();
                try {
                    super.updateCache(inputBuilder, outputBuilder);
                }
                finally {
                    this.lock.writeLock().unlock();
                }
            }
        }

        public boolean canFork() {
            return this.delegate.canFork();
        }

        @Override
        public EquivalenceOracle.MealyEquivalenceOracle<I, O> createCacheConsistencyTest() {
            return new ThreadSafeMealyCacheConsistencyTest(super.createCacheConsistencyTest(), this.lock);
        }

        public SUL<I, O> fork() {
            return new ThreadSafeSULCacheImpl<S, I, T, O>(this.incMealy, this.lock, this.mealyTs, this.delegate.fork());
        }
    }
}

