/*
 * Decompiled with CFR 0.152.
 */
package de.learnlib.filter.cache.sul;

import de.learnlib.Resumable;
import de.learnlib.filter.cache.LearningCache;
import de.learnlib.filter.cache.mealy.MealyCacheConsistencyTest;
import de.learnlib.logging.Category;
import de.learnlib.oracle.EquivalenceOracle;
import de.learnlib.sul.SUL;
import net.automatalib.alphabet.SupportsGrowingAlphabet;
import net.automatalib.incremental.mealy.IncrementalMealyBuilder;
import net.automatalib.ts.output.MealyTransitionSystem;
import net.automatalib.word.WordBuilder;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

abstract class AbstractSULCache<I, O, C extends SULCacheState<I, O>>
implements SUL<I, O>,
LearningCache.MealyLearningCache<I, O>,
SupportsGrowingAlphabet<I>,
Resumable<C> {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractSULCache.class);
    private final AbstractSULCacheImpl<?, I, ?, O, C> impl;

    AbstractSULCache(AbstractSULCacheImpl<?, I, ?, O, C> cacheImpl) {
        this.impl = cacheImpl;
    }

    public void pre() {
        this.impl.pre();
    }

    public void post() {
        this.impl.post();
    }

    public O step(I in) {
        return this.impl.step(in);
    }

    public boolean canFork() {
        return this.impl.canFork();
    }

    public SUL<I, O> fork() {
        return this.impl.fork();
    }

    public EquivalenceOracle.MealyEquivalenceOracle<I, O> createCacheConsistencyTest() {
        return this.impl.createCacheConsistencyTest();
    }

    public void addAlphabetSymbol(I symbol) {
        this.impl.addAlphabetSymbol(symbol);
    }

    public C suspend() {
        return (C)((SULCacheState)this.impl.suspend());
    }

    public void resume(C state) {
        this.impl.resume(state);
    }

    public int size() {
        return this.impl.incMealy.asGraph().size();
    }

    public static class SULCacheState<I, O> {
        final IncrementalMealyBuilder<I, O> builder;

        SULCacheState(IncrementalMealyBuilder<I, O> builder) {
            this.builder = builder;
        }
    }

    static abstract class AbstractSULCacheImpl<S, I, T, O, C extends SULCacheState<I, O>>
    implements SUL<I, O>,
    LearningCache.MealyLearningCache<I, O>,
    SupportsGrowingAlphabet<I>,
    Resumable<C> {
        protected IncrementalMealyBuilder<I, O> incMealy;
        protected MealyTransitionSystem<S, I, T, O> mealyTs;
        protected final SUL<I, O> delegate;
        private final WordBuilder<I> inputWord = new WordBuilder();
        private final WordBuilder<O> outputWord = new WordBuilder();
        private boolean delegatePreCalled;
        protected @Nullable S current;

        AbstractSULCacheImpl(IncrementalMealyBuilder<I, O> incMealy, MealyTransitionSystem<S, I, T, O> mealyTs, SUL<I, O> sul) {
            this.incMealy = incMealy;
            this.mealyTs = mealyTs;
            this.delegate = sul;
        }

        public void pre() {
            this.current = this.mealyTs.getInitialState();
        }

        public O step(I in) {
            Object out = null;
            if (this.current != null) {
                Object trans = this.mealyTs.getTransition(this.current, in);
                if (trans != null) {
                    out = this.mealyTs.getTransitionOutput(trans);
                    this.current = this.mealyTs.getSuccessor(trans);
                    assert (this.current != null);
                } else {
                    this.requiredInitializedDelegate();
                    this.current = null;
                    for (Object prevSym : this.inputWord) {
                        this.outputWord.append(this.delegate.step(prevSym));
                    }
                }
            }
            this.inputWord.append(in);
            if (this.current == null) {
                out = this.delegate.step(in);
                this.postNewStepHook();
                this.outputWord.add(out);
            }
            return (O)out;
        }

        public void post() {
            this.updateCache(this.inputWord, this.outputWord);
            if (this.delegatePreCalled) {
                this.delegate.post();
                this.delegatePreCalled = false;
            }
            this.inputWord.clear();
            this.outputWord.clear();
            this.current = null;
        }

        public EquivalenceOracle.MealyEquivalenceOracle<I, O> createCacheConsistencyTest() {
            return new MealyCacheConsistencyTest<I, O>(this.incMealy);
        }

        public void addAlphabetSymbol(I symbol) {
            this.incMealy.addAlphabetSymbol(symbol);
        }

        public void resume(C state) {
            Class<?> stateClass;
            Class<?> thisClass = this.incMealy.getClass();
            if (!thisClass.equals(stateClass = ((SULCacheState)state).builder.getClass())) {
                LOGGER.warn(Category.DATASTRUCTURE, "You currently plan to use a '{}', but the state contained a '{}'. This may yield unexpected behavior.", thisClass, stateClass);
            }
            this.incMealy = ((SULCacheState)state).builder;
            this.mealyTs = this.incMealy.asTransitionSystem();
        }

        protected void requiredInitializedDelegate() {
            if (!this.delegatePreCalled) {
                this.delegate.pre();
            }
            this.delegatePreCalled = true;
        }

        protected void postNewStepHook() {
        }

        protected void updateCache(WordBuilder<I> inputBuilder, WordBuilder<O> outputBuilder) {
            if (!outputBuilder.isEmpty()) {
                this.incMealy.insert(inputBuilder.toWord(), outputBuilder.toWord());
            }
        }
    }
}

