/*
 * Decompiled with CFR 0.152.
 */
package de.learnlib.filter.cache.mealy;

import de.learnlib.Resumable;
import de.learnlib.filter.cache.LearningCache;
import de.learnlib.oracle.AdaptiveMembershipOracle;
import de.learnlib.oracle.EquivalenceOracle;
import de.learnlib.query.AdaptiveQuery;
import de.learnlib.query.DefaultQuery;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Objects;
import net.automatalib.alphabet.Alphabet;
import net.automatalib.alphabet.SupportsGrowingAlphabet;
import net.automatalib.automaton.UniversalDeterministicAutomaton;
import net.automatalib.automaton.impl.CompactTransition;
import net.automatalib.automaton.transducer.MealyMachine;
import net.automatalib.automaton.transducer.impl.CompactMealy;
import net.automatalib.util.automaton.equivalence.NearLinearEquivalenceTest;
import net.automatalib.word.Word;
import net.automatalib.word.WordBuilder;
import org.checkerframework.checker.nullness.qual.NonNull;

public class AdaptiveQueryCache<I, O>
implements AdaptiveMembershipOracle<I, O>,
LearningCache<MealyMachine<?, I, ?, O>, I, Word<O>>,
SupportsGrowingAlphabet<I>,
Resumable<AdaptiveQueryCacheState<I, O>> {
    private final AdaptiveMembershipOracle<I, O> delegate;
    private CompactMealy<I, O> cache;
    private Integer init;

    public AdaptiveQueryCache(AdaptiveMembershipOracle<I, O> delegate, Alphabet<I> alphabet) {
        this.delegate = delegate;
        this.cache = new CompactMealy(alphabet);
        this.init = (Integer)this.cache.addInitialState();
    }

    public void processQueries(Collection<? extends AdaptiveQuery<I, O>> queries) {
        ArrayDeque<AdaptiveQuery<I, O>> queue = new ArrayDeque<AdaptiveQuery<I, O>>(queries);
        ArrayList<TrackingQuery> unanswered = new ArrayList<TrackingQuery>(queue.size());
        while (!queue.isEmpty()) {
            block1: while (!queue.isEmpty()) {
                AdaptiveQuery.Response response;
                @NonNull AdaptiveQuery query = (AdaptiveQuery)queue.poll();
                WordBuilder trace = new WordBuilder();
                Integer curr = this.init;
                do {
                    Object input = query.getInput();
                    CompactTransition trans = (CompactTransition)this.cache.getTransition(curr, input);
                    trace.add(input);
                    if (trans == null) {
                        unanswered.add(new TrackingQuery(query, trace));
                        continue block1;
                    }
                    Object output = this.cache.getTransitionOutput(trans);
                    response = query.processOutput(output);
                    if (response == AdaptiveQuery.Response.RESET) {
                        curr = this.init;
                        trace.clear();
                        continue;
                    }
                    curr = this.cache.getSuccessor((Object)trans);
                } while (response != AdaptiveQuery.Response.FINISHED);
            }
            this.delegate.processQueries(unanswered);
            for (TrackingQuery query : unanswered) {
                Word input = query.inputBuilder.toWord();
                Word output = query.outputBuilder.toWord();
                assert (input.length() == output.length());
                this.insert(input, output);
                if (query.isFinished) continue;
                queue.add(query.delegate);
            }
            unanswered.clear();
        }
    }

    @Override
    public EquivalenceOracle<MealyMachine<?, I, ?, O>, I, Word<O>> createCacheConsistencyTest() {
        return (hypothesis, alphabet) -> {
            Word sepWord = NearLinearEquivalenceTest.findSeparatingWord(this.cache, (UniversalDeterministicAutomaton)hypothesis, (Collection)alphabet, (boolean)true);
            if (sepWord != null) {
                return new DefaultQuery(sepWord, (Object)((Word)this.cache.computeOutput((Iterable)sepWord)));
            }
            return null;
        };
    }

    public AdaptiveQueryCacheState<I, O> suspend() {
        return new AdaptiveQueryCacheState<I, O>(this.cache);
    }

    public void resume(AdaptiveQueryCacheState<I, O> state) {
        this.cache = state.getCache();
        this.init = Objects.requireNonNull(this.cache.getInitialState());
    }

    public void addAlphabetSymbol(I symbol) {
        this.cache.addAlphabetSymbol(symbol);
    }

    public MealyMachine<Integer, I, ?, O> getCache() {
        return this.cache;
    }

    public Integer getInit() {
        return this.init;
    }

    public Integer insert(Word<I> input, Word<O> output) {
        return this.insert(this.init, input, output);
    }

    public Integer insert(Integer state, Word<I> input, Word<O> output) {
        assert (input.length() == output.length());
        Integer curr = state;
        for (int i = 0; i < input.size(); ++i) {
            Object in = input.getSymbol(i);
            Object out = output.getSymbol(i);
            CompactTransition trans = (CompactTransition)this.cache.getTransition(curr, in);
            if (trans == null) {
                Integer next = (Integer)this.cache.addState();
                this.cache.addTransition((Object)curr, in, (Object)next, out);
                curr = next;
                continue;
            }
            assert (Objects.equals(out, this.cache.getTransitionOutput(trans))) : "Inconsistent observations";
            curr = this.cache.getSuccessor((Object)trans);
        }
        return curr;
    }

    public static class AdaptiveQueryCacheState<I, O> {
        private final CompactMealy<I, O> cache;

        AdaptiveQueryCacheState(CompactMealy<I, O> cache) {
            this.cache = cache;
        }

        CompactMealy<I, O> getCache() {
            return this.cache;
        }
    }

    private class TrackingQuery
    implements AdaptiveQuery<I, O> {
        private final AdaptiveQuery<I, O> delegate;
        private final WordBuilder<I> inputBuilder;
        private final WordBuilder<O> outputBuilder;
        private final int prefixLength;
        private int prefixIdx;
        private boolean isFinished;

        TrackingQuery(AdaptiveQuery<I, O> delegate, WordBuilder<I> inputBuilder) {
            this.delegate = delegate;
            this.inputBuilder = inputBuilder;
            this.outputBuilder = new WordBuilder();
            this.prefixLength = inputBuilder.size();
            this.prefixIdx = 0;
            this.isFinished = false;
        }

        public I getInput() {
            if (this.prefixIdx < this.prefixLength) {
                return this.inputBuilder.getSymbol(this.prefixIdx);
            }
            Object input = this.delegate.getInput();
            this.inputBuilder.append(input);
            return input;
        }

        public AdaptiveQuery.Response processOutput(O out) {
            this.outputBuilder.append(out);
            ++this.prefixIdx;
            if (this.prefixIdx < this.prefixLength) {
                return AdaptiveQuery.Response.SYMBOL;
            }
            AdaptiveQuery.Response response = this.delegate.processOutput(out);
            switch (response) {
                case FINISHED: {
                    this.isFinished = true;
                    return AdaptiveQuery.Response.FINISHED;
                }
                case RESET: {
                    return AdaptiveQuery.Response.FINISHED;
                }
            }
            return response;
        }
    }
}

