/*
 * Decompiled with CFR 0.152.
 */
package de.learnlib.filter.cache.dfa;

import de.learnlib.filter.cache.dfa.DFACacheOracle;
import de.learnlib.filter.cache.dfa.DFAHashCacheOracle;
import de.learnlib.oracle.MembershipOracle;
import net.automatalib.alphabet.Alphabet;
import net.automatalib.incremental.dfa.dag.IncrementalDFADAGBuilder;
import net.automatalib.incremental.dfa.dag.IncrementalPCDFADAGBuilder;
import net.automatalib.incremental.dfa.tree.IncrementalDFATreeBuilder;
import net.automatalib.incremental.dfa.tree.IncrementalPCDFATreeBuilder;

public final class DFACaches {
    private DFACaches() {
    }

    public static <I> DFACacheOracle<I> createCache(Alphabet<I> alphabet, MembershipOracle<I, Boolean> mqOracle) {
        return DFACaches.createDAGCache(alphabet, mqOracle);
    }

    public static <I> DFACacheOracle<I> createDAGCache(Alphabet<I> alphabet, MembershipOracle<I, Boolean> mqOracle) {
        return new DFACacheOracle<I>(new IncrementalDFADAGBuilder(alphabet), mqOracle);
    }

    public static <I> DFACacheOracle<I> createDAGPCCache(Alphabet<I> alphabet, MembershipOracle<I, Boolean> mqOracle) {
        return new DFACacheOracle<I>(new IncrementalPCDFADAGBuilder(alphabet), mqOracle);
    }

    public static <I> DFACacheOracle<I> createTreeCache(Alphabet<I> alphabet, MembershipOracle<I, Boolean> mqOracle) {
        return new DFACacheOracle<I>(new IncrementalDFATreeBuilder(alphabet), mqOracle);
    }

    public static <I> DFACacheOracle<I> createTreePCCache(Alphabet<I> alphabet, MembershipOracle<I, Boolean> mqOracle) {
        return new DFACacheOracle<I>(new IncrementalPCDFATreeBuilder(alphabet), mqOracle);
    }

    public static <I> DFAHashCacheOracle<I> createHashCache(MembershipOracle<I, Boolean> mqOracle) {
        return new DFAHashCacheOracle<I>(mqOracle);
    }
}

