/*
 * Decompiled with CFR 0.152.
 */
package de.learnlib.filter.cache.dfa;

import de.learnlib.Resumable;
import de.learnlib.filter.cache.LearningCacheOracle;
import de.learnlib.filter.cache.dfa.DFACacheConsistencyTest;
import de.learnlib.filter.cache.dfa.ProxyQuery;
import de.learnlib.logging.Category;
import de.learnlib.oracle.EquivalenceOracle;
import de.learnlib.oracle.MembershipOracle;
import de.learnlib.query.Query;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import net.automatalib.alphabet.SupportsGrowingAlphabet;
import net.automatalib.common.util.Pair;
import net.automatalib.incremental.dfa.Acceptance;
import net.automatalib.incremental.dfa.IncrementalDFABuilder;
import net.automatalib.word.Word;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DFACacheOracle<I>
implements LearningCacheOracle.DFALearningCacheOracle<I>,
SupportsGrowingAlphabet<I>,
Resumable<DFACacheOracleState<I>> {
    private static final Logger LOGGER = LoggerFactory.getLogger(DFACacheOracle.class);
    private IncrementalDFABuilder<I> incDfa;
    private final MembershipOracle<I, Boolean> delegate;

    DFACacheOracle(IncrementalDFABuilder<I> incDfa, MembershipOracle<I, Boolean> delegate) {
        this.incDfa = incDfa;
        this.delegate = delegate;
    }

    public EquivalenceOracle.DFAEquivalenceOracle<I> createCacheConsistencyTest() {
        return new DFACacheConsistencyTest<I>(this.incDfa);
    }

    public void processQueries(Collection<? extends Query<I, Boolean>> queries) {
        if (queries.isEmpty()) {
            return;
        }
        Pair<Collection<ProxyQuery<I>>, Collection<Query<I, Boolean>>> cacheResult = this.queryCache(queries);
        Collection unanswered = (Collection)cacheResult.getFirst();
        Collection duplicates = (Collection)cacheResult.getSecond();
        this.delegate.processQueries(unanswered);
        this.updateCache(unanswered);
        if (!duplicates.isEmpty()) {
            this.queryCache(duplicates);
        }
    }

    public void addAlphabetSymbol(I symbol) {
        this.incDfa.addAlphabetSymbol(symbol);
    }

    public DFACacheOracleState<I> suspend() {
        return new DFACacheOracleState<I>(this.incDfa);
    }

    public void resume(DFACacheOracleState<I> state) {
        Class<?> stateClass;
        Class<?> thisClass = this.incDfa.getClass();
        if (!thisClass.equals(stateClass = state.getBuilder().getClass())) {
            LOGGER.warn(Category.DATASTRUCTURE, "You currently plan to use a '{}', but the state contained a '{}'. This may yield unexpected behavior.", thisClass, stateClass);
        }
        this.incDfa = state.getBuilder();
    }

    Pair<Collection<ProxyQuery<I>>, Collection<Query<I, Boolean>>> queryCache(Collection<? extends Query<I, Boolean>> queries) {
        ArrayList<ProxyQuery<I>> unanswered = new ArrayList<ProxyQuery<I>>();
        ArrayList<Query<I, Boolean>> duplicates = new ArrayList<Query<I, Boolean>>();
        HashSet<Word> cache = new HashSet<Word>();
        for (Query<I, Boolean> q : queries) {
            Word input = q.getInput();
            Acceptance acc = this.incDfa.lookup(input);
            if (acc == Acceptance.DONT_KNOW) {
                if (cache.add(input)) {
                    unanswered.add(new ProxyQuery<I>(q));
                    continue;
                }
                duplicates.add(q);
                continue;
            }
            q.answer((Object)acc.toBoolean());
        }
        return Pair.of(unanswered, duplicates);
    }

    void updateCache(Collection<? extends ProxyQuery<I>> queries) {
        for (ProxyQuery<I> q : queries) {
            this.incDfa.insert(q.getInput(), q.getAnswer().booleanValue());
        }
    }

    public static class DFACacheOracleState<I> {
        private final IncrementalDFABuilder<I> builder;

        DFACacheOracleState(IncrementalDFABuilder<I> builder) {
            this.builder = builder;
        }

        IncrementalDFABuilder<I> getBuilder() {
            return this.builder;
        }
    }
}

