/*
 * Decompiled with CFR 0.152.
 */
package de.learnlib.filter.cache;

import de.learnlib.oracle.MembershipOracle;
import de.learnlib.query.DefaultQuery;
import de.learnlib.query.Query;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.WeakHashMap;

public class InterningMembershipOracle<I, D>
implements MembershipOracle<I, D> {
    private final MembershipOracle<I, D> delegate;
    private final Map<D, WeakReference<D>> cache;

    public InterningMembershipOracle(MembershipOracle<I, D> delegate) {
        this.delegate = delegate;
        this.cache = new WeakHashMap<D, WeakReference<D>>();
    }

    public void processQueries(Collection<? extends Query<I, D>> queries) {
        ArrayList<DefaultQuery> delegates = new ArrayList<DefaultQuery>(queries.size());
        for (Query<I, D> q : queries) {
            delegates.add(new DefaultQuery(q));
        }
        this.delegate.processQueries(delegates);
        Iterator<Query<I, D>> origIter = queries.iterator();
        Iterator delegateIter = delegates.iterator();
        while (origIter.hasNext() && delegateIter.hasNext()) {
            Object origOutput;
            Query<I, D> origNext = origIter.next();
            DefaultQuery delegateNext = (DefaultQuery)delegateIter.next();
            Object delegateOutput = delegateNext.getOutput();
            while ((origOutput = this.cache.computeIfAbsent(delegateOutput, k -> new WeakReference<Object>(delegateOutput)).get()) == null) {
            }
            origNext.answer(origOutput);
        }
        assert (!origIter.hasNext() && !delegateIter.hasNext());
    }
}

