/*
 * Decompiled with CFR 0.152.
 */
package de.learnlib.filter.cache.sul;

import de.learnlib.api.Resumable;
import de.learnlib.api.SUL;
import de.learnlib.filter.cache.sul.AbstractSULCache;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import net.automatalib.incremental.mealy.IncrementalMealyBuilder;
import net.automatalib.incremental.mealy.dag.IncrementalMealyDAGBuilder;
import net.automatalib.incremental.mealy.tree.IncrementalMealyTreeBuilder;
import net.automatalib.ts.output.MealyTransitionSystem;
import net.automatalib.words.Alphabet;

public class SULCache<I, O>
extends AbstractSULCache<I, O>
implements Resumable<SULCacheState<I, O>> {
    private final SULCacheImpl<?, I, ?, O> impl;

    SULCache(IncrementalMealyBuilder<I, O> incMealy, SUL<I, O> sul) {
        this(new SULCacheImpl(incMealy, new ReentrantReadWriteLock(), incMealy.asTransitionSystem(), sul));
    }

    private <S, T> SULCache(SULCacheImpl<S, I, T, O> cacheImpl) {
        super(cacheImpl);
        this.impl = cacheImpl;
    }

    public static <I, O> SULCache<I, O> createTreeCache(Alphabet<I> alphabet, SUL<I, O> sul) {
        return new SULCache<I, O>(new IncrementalMealyTreeBuilder(alphabet), sul);
    }

    public static <I, O> SULCache<I, O> createDAGCache(Alphabet<I> alphabet, SUL<I, O> sul) {
        return new SULCache<I, O>(new IncrementalMealyDAGBuilder(alphabet), sul);
    }

    public SULCacheState<I, O> suspend() {
        return this.impl.suspend();
    }

    public void resume(SULCacheState<I, O> state) {
        this.impl.resume(state);
    }

    public static final class SULCacheState<I, O>
    extends AbstractSULCache.AbstractSULCacheState<I, O> {
        SULCacheState(IncrementalMealyBuilder<I, O> builder) {
            super(builder);
        }
    }

    private static final class SULCacheImpl<S, I, T, O>
    extends AbstractSULCache.AbstractSULCacheImpl<S, I, T, O, SULCacheState<I, O>> {
        SULCacheImpl(IncrementalMealyBuilder<I, O> incMealy, ReadWriteLock lock, MealyTransitionSystem<S, I, T, O> mealyTs, SUL<I, O> sul) {
            super(incMealy, lock, mealyTs, sul);
        }

        public SUL<I, O> fork() {
            return new SULCacheImpl<S, I, T, O>(this.incMealy, this.incMealyLock, this.mealyTs, this.delegate.fork());
        }

        public SULCacheState<I, O> suspend() {
            return new SULCacheState(this.incMealy);
        }
    }
}

