/*
 * Decompiled with CFR 0.152.
 */
package de.learnlib.filter.cache.sul;

import de.learnlib.api.Resumable;
import de.learnlib.api.SUL;
import de.learnlib.api.oracle.EquivalenceOracle;
import de.learnlib.filter.cache.LearningCache;
import de.learnlib.filter.cache.mealy.MealyCacheConsistencyTest;
import java.io.Serializable;
import java.util.List;
import java.util.concurrent.locks.ReadWriteLock;
import net.automatalib.SupportsGrowingAlphabet;
import net.automatalib.incremental.mealy.IncrementalMealyBuilder;
import net.automatalib.ts.output.MealyTransitionSystem;
import net.automatalib.words.WordBuilder;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

abstract class AbstractSULCache<I, O>
implements SUL<I, O>,
LearningCache.MealyLearningCache<I, O>,
SupportsGrowingAlphabet<I> {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractSULCache.class);
    private final AbstractSULCacheImpl<?, I, ?, O, ? extends AbstractSULCacheState<I, O>> impl;

    protected <S, T> AbstractSULCache(AbstractSULCacheImpl<S, I, T, O, ? extends AbstractSULCacheState<I, O>> cacheImpl) {
        this.impl = cacheImpl;
    }

    public void pre() {
        this.impl.pre();
    }

    public void post() {
        this.impl.post();
    }

    public O step(I in) {
        return this.impl.step(in);
    }

    public boolean canFork() {
        return this.impl.canFork();
    }

    public SUL<I, O> fork() {
        return this.impl.fork();
    }

    public EquivalenceOracle.MealyEquivalenceOracle<I, O> createCacheConsistencyTest() {
        return this.impl.createCacheConsistencyTest();
    }

    public void addAlphabetSymbol(I symbol) {
        this.impl.addAlphabetSymbol(symbol);
    }

    public int size() {
        return this.impl.incMealy.asGraph().size();
    }

    static abstract class AbstractSULCacheState<I, O>
    implements Serializable {
        final IncrementalMealyBuilder<I, O> builder;

        protected AbstractSULCacheState(IncrementalMealyBuilder<I, O> builder) {
            this.builder = builder;
        }
    }

    static abstract class AbstractSULCacheImpl<S, I, T, O, C extends AbstractSULCacheState<I, O>>
    implements SUL<I, O>,
    LearningCache.MealyLearningCache<I, O>,
    SupportsGrowingAlphabet<I>,
    Resumable<C> {
        protected IncrementalMealyBuilder<I, O> incMealy;
        protected MealyTransitionSystem<S, I, T, O> mealyTs;
        protected final SUL<I, O> delegate;
        protected final ReadWriteLock incMealyLock;
        private final WordBuilder<I> inputWord = new WordBuilder();
        private final WordBuilder<O> outputWord = new WordBuilder();
        private boolean delegatePreCalled;
        protected @Nullable S current;

        AbstractSULCacheImpl(IncrementalMealyBuilder<I, O> incMealy, ReadWriteLock lock, MealyTransitionSystem<S, I, T, O> mealyTs, SUL<I, O> sul) {
            this.incMealy = incMealy;
            this.mealyTs = mealyTs;
            this.delegate = sul;
            this.incMealyLock = lock;
        }

        public void pre() {
            this.incMealyLock.readLock().lock();
            this.current = this.mealyTs.getInitialState();
        }

        public O step(I in) {
            Object out = null;
            if (this.current != null) {
                Object trans = this.mealyTs.getTransition(this.current, in);
                if (trans != null) {
                    out = this.mealyTs.getTransitionOutput(trans);
                    this.current = this.mealyTs.getSuccessor(trans);
                    assert (this.current != null);
                } else {
                    this.incMealyLock.readLock().unlock();
                    this.current = null;
                    this.requiredInitializedDelegate();
                    for (Object prevSym : this.inputWord) {
                        this.outputWord.append(this.delegate.step(prevSym));
                    }
                }
            }
            this.inputWord.append(in);
            if (this.current == null) {
                out = this.delegate.step(in);
                this.postNewStepHook();
                this.outputWord.add(out);
            }
            return (O)out;
        }

        public void post() {
            if (this.outputWord.isEmpty()) {
                this.incMealyLock.readLock().unlock();
            } else {
                this.incMealyLock.writeLock().lock();
                try {
                    this.incMealy.insert(this.inputWord.toWord(), this.outputWord.toWord());
                    this.postCacheWriteHook((List<I>)this.inputWord);
                }
                finally {
                    this.incMealyLock.writeLock().unlock();
                }
            }
            if (this.delegatePreCalled) {
                this.delegate.post();
                this.delegatePreCalled = false;
            }
            this.inputWord.clear();
            this.outputWord.clear();
            this.current = null;
        }

        public boolean canFork() {
            return this.delegate.canFork();
        }

        public EquivalenceOracle.MealyEquivalenceOracle<I, O> createCacheConsistencyTest() {
            return new MealyCacheConsistencyTest<I, O>(this.incMealy, this.incMealyLock);
        }

        public void addAlphabetSymbol(I symbol) {
            this.incMealy.addAlphabetSymbol(symbol);
        }

        public void resume(C state) {
            Class<?> stateClass;
            Class<?> thisClass = this.incMealy.getClass();
            if (!thisClass.equals(stateClass = ((AbstractSULCacheState)state).builder.getClass())) {
                LOGGER.warn("You currently plan to use a '{}', but the state contained a '{}'. This may yield unexpected behavior.", thisClass, stateClass);
            }
            this.incMealy = ((AbstractSULCacheState)state).builder;
            this.mealyTs = this.incMealy.asTransitionSystem();
        }

        protected void requiredInitializedDelegate() {
            if (!this.delegatePreCalled) {
                this.delegate.pre();
            }
            this.delegatePreCalled = true;
        }

        protected void postNewStepHook() {
        }

        protected void postCacheWriteHook(List<I> input) {
        }
    }
}

