/*
 * Decompiled with CFR 0.152.
 */
package de.learnlib.filter.cache.mealy;

import de.learnlib.api.Resumable;
import de.learnlib.api.oracle.EquivalenceOracle;
import de.learnlib.api.oracle.SymbolQueryOracle;
import de.learnlib.api.query.DefaultQuery;
import de.learnlib.filter.cache.LearningCacheOracle;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import net.automatalib.automata.transducers.MealyMachine;
import net.automatalib.automata.transducers.impl.compact.CompactMealy;
import net.automatalib.util.automata.equivalence.NearLinearEquivalenceTest;
import net.automatalib.words.Alphabet;
import net.automatalib.words.Word;
import org.checkerframework.checker.nullness.qual.Nullable;

public class SymbolQueryCache<I, O>
implements SymbolQueryOracle<I, O>,
LearningCacheOracle.MealyLearningCacheOracle<I, O>,
Resumable<SymbolQueryCacheState<I, O>> {
    private CompactMealy<I, O> cache;
    private final SymbolQueryOracle<I, O> delegate;
    private final List<I> currentTrace;
    private Integer currentState;
    private boolean currentTraceValid;

    public SymbolQueryCache(SymbolQueryOracle<I, O> delegate, Alphabet<I> alphabet) {
        this.delegate = delegate;
        this.cache = new CompactMealy(alphabet);
        this.currentState = (Integer)this.cache.addInitialState();
        this.currentTrace = new ArrayList<I>();
        this.currentTraceValid = false;
    }

    public O query(I i) {
        Integer nextState;
        if (this.currentTraceValid) {
            Integer succ = (Integer)this.cache.getSuccessor((Object)this.currentState, i);
            if (succ != null) {
                Object output = this.cache.getOutput((Object)this.currentState, i);
                assert (output != null);
                this.currentTrace.add(i);
                this.currentState = succ;
                return (O)output;
            }
            this.currentTraceValid = false;
            this.delegate.reset();
            this.currentTrace.forEach(arg_0 -> this.delegate.query(arg_0));
        }
        Object output = this.delegate.query(i);
        Integer succ = (Integer)this.cache.getSuccessor((Object)this.currentState, i);
        if (succ == null) {
            Integer newState = (Integer)this.cache.addState();
            this.cache.addTransition((Object)this.currentState, i, (Object)newState, output);
            nextState = newState;
        } else {
            assert (Objects.equals(this.cache.getOutput((Object)this.currentState, i), output));
            nextState = succ;
        }
        this.currentState = nextState;
        return (O)output;
    }

    public void reset() {
        Integer init = this.cache.getInitialState();
        assert (init != null);
        this.currentState = init;
        this.currentTrace.clear();
        this.currentTraceValid = true;
    }

    @Override
    public EquivalenceOracle<MealyMachine<?, I, ?, O>, I, Word<O>> createCacheConsistencyTest() {
        return this::findCounterexample;
    }

    private @Nullable DefaultQuery<I, Word<O>> findCounterexample(MealyMachine<?, I, ?, O> hypothesis, Collection<? extends I> alphabet) {
        Word sepWord = NearLinearEquivalenceTest.findSeparatingWord(this.cache, hypothesis, alphabet, (boolean)true);
        if (sepWord != null) {
            return new DefaultQuery(sepWord, this.cache.computeOutput((Iterable)sepWord));
        }
        return null;
    }

    public SymbolQueryCacheState<I, O> suspend() {
        return new SymbolQueryCacheState<I, O>(this.cache);
    }

    public void resume(SymbolQueryCacheState<I, O> state) {
        this.cache = state.getCache();
    }

    public static class SymbolQueryCacheState<I, O>
    implements Serializable {
        private final CompactMealy<I, O> cache;

        SymbolQueryCacheState(CompactMealy<I, O> cache) {
            this.cache = cache;
        }

        CompactMealy<I, O> getCache() {
            return this.cache;
        }
    }
}

