/*
 * Decompiled with CFR 0.152.
 */
package de.learnlib.filter.cache.mealy;

import de.learnlib.api.query.AbstractQuery;
import de.learnlib.api.query.Query;
import java.util.ArrayList;
import java.util.List;
import net.automatalib.commons.util.mappings.Mapping;
import net.automatalib.words.Word;
import net.automatalib.words.WordBuilder;
import org.checkerframework.checker.nullness.qual.Nullable;

final class MasterQuery<I, O>
extends AbstractQuery<I, Word<O>> {
    private final @Nullable Mapping<? super O, ? extends O> errorSyms;
    private final @Nullable List<Query<I, Word<O>>> slaves;
    private Word<O> answer;

    MasterQuery(Word<I> word) {
        this(word, (Mapping)null);
    }

    MasterQuery(Word<I> word, @Nullable Mapping<? super O, ? extends O> errorSyms) {
        super(word);
        this.errorSyms = errorSyms;
        this.slaves = new ArrayList<Query<I, Word<O>>>();
    }

    MasterQuery(Word<I> word, Word<O> output) {
        super(word);
        this.answer = output;
        this.errorSyms = null;
        this.slaves = null;
    }

    public Word<O> getAnswer() {
        return this.answer;
    }

    public boolean isAnswered() {
        return this.answer != null;
    }

    public void answer(Word<O> output) {
        assert (this.slaves != null);
        this.answer = this.truncateOutput(output);
        for (Query<I, Word<O>> slave : this.slaves) {
            this.answerSlave(slave);
        }
    }

    private Word<O> truncateOutput(Word<O> output) {
        if (this.errorSyms == null) {
            return output;
        }
        int maxLen = output.length() - 1;
        int i = 0;
        Object repSym = null;
        while (i < maxLen && repSym == null) {
            Object sym = output.getSymbol(i++);
            repSym = this.errorSyms.get(sym);
        }
        if (repSym == null) {
            return output;
        }
        WordBuilder wb = new WordBuilder(maxLen + 1);
        wb.append(output.prefix(i));
        wb.repeatAppend(1 + maxLen - i, repSym);
        return wb.toWord();
    }

    private void answerSlave(Query<I, Word<O>> slave) {
        int start = slave.getPrefix().length();
        int end = start + slave.getSuffix().length();
        slave.answer((Object)this.answer.subWord(start, end));
    }

    public String toString() {
        return this.toStringWithAnswer(this.answer);
    }

    public void addSlave(Query<I, Word<O>> slave) {
        if (this.slaves == null) {
            this.answerSlave(slave);
        } else {
            this.slaves.add(slave);
        }
    }
}

