/*
 * Decompiled with CFR 0.152.
 */
package de.learnlib.filter.cache.mealy;

import de.learnlib.api.oracle.MembershipOracle;
import de.learnlib.api.query.Query;
import de.learnlib.filter.cache.LearningCacheOracle;
import de.learnlib.filter.cache.mealy.MasterQuery;
import de.learnlib.filter.cache.mealy.MealyCacheConsistencyTest;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import net.automatalib.SupportsGrowingAlphabet;
import net.automatalib.commons.util.comparison.CmpUtil;
import net.automatalib.commons.util.mappings.Mapping;
import net.automatalib.incremental.mealy.IncrementalMealyBuilder;
import net.automatalib.words.Word;
import net.automatalib.words.WordBuilder;
import net.automatalib.words.impl.GrowingMapAlphabet;
import org.checkerframework.checker.nullness.qual.Nullable;

class InternalMealyCacheOracle<I, O>
implements LearningCacheOracle.MealyLearningCacheOracle<I, O>,
SupportsGrowingAlphabet<I> {
    private final MembershipOracle<I, Word<O>> delegate;
    protected IncrementalMealyBuilder<I, O> incMealy;
    protected final ReadWriteLock incMealyLock;
    private final Comparator<? super Query<I, ?>> queryCmp;
    private final @Nullable Mapping<? super O, ? extends O> errorSyms;

    InternalMealyCacheOracle(IncrementalMealyBuilder<I, O> incrementalBuilder, @Nullable Mapping<? super O, ? extends O> errorSyms, MembershipOracle<I, Word<O>> delegate) {
        this(incrementalBuilder, errorSyms, delegate, new DynamicSymbolComparator());
    }

    InternalMealyCacheOracle(IncrementalMealyBuilder<I, O> incrementalBuilder, @Nullable Mapping<? super O, ? extends O> errorSyms, MembershipOracle<I, Word<O>> delegate, Comparator<I> comparator) {
        this.incMealy = incrementalBuilder;
        this.incMealyLock = new ReentrantReadWriteLock();
        this.queryCmp = new ReverseLexCmp<I>(comparator);
        this.errorSyms = errorSyms;
        this.delegate = delegate;
    }

    public int getCacheSize() {
        return this.incMealy.asGraph().size();
    }

    public MealyCacheConsistencyTest<I, O> createCacheConsistencyTest() {
        return new MealyCacheConsistencyTest<I, O>(this.incMealy, this.incMealyLock);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processQueries(Collection<? extends Query<I, Word<O>>> queries) {
        if (queries.isEmpty()) {
            return;
        }
        ArrayList<Query<I, Word<O>>> qrys = new ArrayList<Query<I, Word<O>>>(queries);
        qrys.sort(this.queryCmp);
        ArrayList<MasterQuery<I, O>> masterQueries = new ArrayList<MasterQuery<I, O>>();
        Iterator it = qrys.iterator();
        Query q = (Query)it.next();
        Word ref = q.getInput();
        this.incMealyLock.readLock().lock();
        try {
            MasterQuery<I, O> master = this.createMasterQuery(ref);
            if (!master.isAnswered()) {
                masterQueries.add(master);
            }
            master.addSlave(q);
            while (it.hasNext()) {
                q = (Query)it.next();
                Word word = q.getInput();
                if (!word.isPrefixOf(ref) && !(master = this.createMasterQuery(word)).isAnswered()) {
                    masterQueries.add(master);
                }
                master.addSlave(q);
                ref = word;
            }
        }
        finally {
            this.incMealyLock.readLock().unlock();
        }
        this.delegate.processQueries(masterQueries);
        this.incMealyLock.writeLock().lock();
        try {
            for (MasterQuery masterQuery : masterQueries) {
                this.postProcess(masterQuery);
            }
        }
        finally {
            this.incMealyLock.writeLock().unlock();
        }
    }

    private MasterQuery<I, O> createMasterQuery(Word<I> word) {
        WordBuilder wb = new WordBuilder(word.size());
        if (this.incMealy.lookup(word, (List)wb)) {
            return new MasterQuery(word, wb.toWord());
        }
        if (this.errorSyms == null) {
            return new MasterQuery(word);
        }
        int wbSize = wb.size();
        if (wbSize == 0) {
            return new MasterQuery<I, O>(word, this.errorSyms);
        }
        Object repSym = this.errorSyms.get(wb.getSymbol(wbSize - 1));
        if (repSym == null) {
            return new MasterQuery<I, O>(word, this.errorSyms);
        }
        wb.repeatAppend(word.length() - wbSize, repSym);
        return new MasterQuery(word, wb.toWord());
    }

    private void postProcess(MasterQuery<I, O> master) {
        Object sym;
        Word word = master.getSuffix();
        Word<O> answer = master.getAnswer();
        if (this.errorSyms == null) {
            this.incMealy.insert(word, answer);
            return;
        }
        int answLen = answer.length();
        int i = 0;
        while (i < answLen && this.errorSyms.get(sym = answer.getSymbol(i++)) == null) {
        }
        if (i == answLen) {
            this.incMealy.insert(word, answer);
        } else {
            this.incMealy.insert(word.prefix(i), answer.prefix(i));
        }
    }

    public void addAlphabetSymbol(I symbol) {
        this.incMealy.addAlphabetSymbol(symbol);
    }

    private static final class DynamicSymbolComparator<I>
    implements Comparator<I>,
    Serializable {
        private final GrowingMapAlphabet<I> alphabet = new GrowingMapAlphabet();

        DynamicSymbolComparator() {
        }

        @Override
        public int compare(I i1, I i2) {
            this.alphabet.addSymbol(i1);
            this.alphabet.addSymbol(i2);
            return this.alphabet.compare(i1, i2);
        }
    }

    private static final class ReverseLexCmp<I>
    implements Comparator<Query<I, ?>>,
    Serializable {
        private final Comparator<I> comparator;

        ReverseLexCmp(Comparator<I> comparator) {
            this.comparator = comparator;
        }

        @Override
        public int compare(Query<I, ?> o1, Query<I, ?> o2) {
            return -CmpUtil.lexCompare((Iterable)o1.getInput(), (Iterable)o2.getInput(), this.comparator);
        }
    }
}

