/*
 * Decompiled with CFR 0.152.
 */
package de.learnlib.filter.cache.dfa;

import de.learnlib.api.Resumable;
import de.learnlib.api.oracle.EquivalenceOracle;
import de.learnlib.api.oracle.MembershipOracle;
import de.learnlib.api.query.Query;
import de.learnlib.filter.cache.LearningCacheOracle;
import de.learnlib.filter.cache.dfa.DFAHashCacheConsistencyTest;
import de.learnlib.filter.cache.dfa.ProxyQuery;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import net.automatalib.automata.fsa.DFA;
import net.automatalib.words.Word;

public class DFAHashCacheOracle<I>
implements LearningCacheOracle.DFALearningCacheOracle<I>,
Resumable<DFAHashCacheOracleState<I>> {
    private final MembershipOracle<I, Boolean> delegate;
    private Map<Word<I>, Boolean> cache;
    private final Lock cacheLock;

    public DFAHashCacheOracle(MembershipOracle<I, Boolean> delegate) {
        this.delegate = delegate;
        this.cache = new HashMap<Word<I>, Boolean>();
        this.cacheLock = new ReentrantLock();
    }

    @Override
    public EquivalenceOracle<DFA<?, I>, I, Boolean> createCacheConsistencyTest() {
        return new DFAHashCacheConsistencyTest<I>(this.cache, this.cacheLock);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processQueries(Collection<? extends Query<I, Boolean>> queries) {
        ArrayList<ProxyQuery<I>> misses = new ArrayList<ProxyQuery<I>>();
        this.cacheLock.lock();
        try {
            for (Query<I, Boolean> query : queries) {
                Word input = query.getInput();
                Boolean answer = this.cache.get(input);
                if (answer != null) {
                    query.answer((Object)answer);
                    continue;
                }
                misses.add(new ProxyQuery<I>(query));
            }
        }
        finally {
            this.cacheLock.unlock();
        }
        this.delegate.processQueries(misses);
        this.cacheLock.lock();
        try {
            for (ProxyQuery proxyQuery : misses) {
                this.cache.put(proxyQuery.getInput(), proxyQuery.getAnswer());
            }
        }
        finally {
            this.cacheLock.unlock();
        }
    }

    public DFAHashCacheOracleState<I> suspend() {
        return new DFAHashCacheOracleState<I>(this.cache);
    }

    public void resume(DFAHashCacheOracleState<I> state) {
        this.cache = state.getCache();
    }

    public static class DFAHashCacheOracleState<I>
    implements Serializable {
        private final Map<Word<I>, Boolean> cache;

        public DFAHashCacheOracleState(Map<Word<I>, Boolean> cache) {
            this.cache = cache;
        }

        public Map<Word<I>, Boolean> getCache() {
            return this.cache;
        }
    }
}

