/*
 * Decompiled with CFR 0.152.
 */
package de.learnlib.filter.cache.dfa;

import de.learnlib.api.oracle.EquivalenceOracle;
import de.learnlib.api.query.DefaultQuery;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.locks.Lock;
import net.automatalib.automata.fsa.DFA;
import net.automatalib.words.Word;
import org.checkerframework.checker.nullness.qual.Nullable;

final class DFAHashCacheConsistencyTest<I>
implements EquivalenceOracle.DFAEquivalenceOracle<I> {
    private final Map<Word<I>, Boolean> cache;
    private final Lock cacheLock;

    DFAHashCacheConsistencyTest(Map<Word<I>, Boolean> cache, Lock cacheLock) {
        this.cache = cache;
        this.cacheLock = cacheLock;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public @Nullable DefaultQuery<I, Boolean> findCounterExample(DFA<?, I> hypothesis, Collection<? extends I> inputs) {
        this.cacheLock.lock();
        try {
            for (Map.Entry<Word<I>, Boolean> cacheEntry : this.cache.entrySet()) {
                Word<I> input = cacheEntry.getKey();
                Boolean answer = cacheEntry.getValue();
                if (hypothesis.computeOutput(input).equals(answer)) continue;
                DefaultQuery defaultQuery = new DefaultQuery(input, (Object)answer);
                return defaultQuery;
            }
            Iterator<Map.Entry<Word<I>, Boolean>> iterator = null;
            return iterator;
        }
        finally {
            this.cacheLock.unlock();
        }
    }
}

