/*
 * Decompiled with CFR 0.152.
 */
package de.learnlib.filter.cache.dfa;

import de.learnlib.api.Resumable;
import de.learnlib.api.oracle.MembershipOracle;
import de.learnlib.api.query.Query;
import de.learnlib.filter.cache.LearningCacheOracle;
import de.learnlib.filter.cache.dfa.DFACacheConsistencyTest;
import de.learnlib.filter.cache.dfa.ProxyQuery;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import net.automatalib.SupportsGrowingAlphabet;
import net.automatalib.incremental.dfa.Acceptance;
import net.automatalib.incremental.dfa.IncrementalDFABuilder;
import net.automatalib.incremental.dfa.dag.IncrementalDFADAGBuilder;
import net.automatalib.incremental.dfa.dag.IncrementalPCDFADAGBuilder;
import net.automatalib.incremental.dfa.tree.IncrementalDFATreeBuilder;
import net.automatalib.incremental.dfa.tree.IncrementalPCDFATreeBuilder;
import net.automatalib.words.Alphabet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DFACacheOracle<I>
implements LearningCacheOracle.DFALearningCacheOracle<I>,
SupportsGrowingAlphabet<I>,
Resumable<DFACacheOracleState<I>> {
    private static final Logger LOGGER = LoggerFactory.getLogger(DFACacheOracle.class);
    private IncrementalDFABuilder<I> incDfa;
    private final ReadWriteLock incDfaLock;
    private final MembershipOracle<I, Boolean> delegate;

    DFACacheOracle(IncrementalDFABuilder<I> incDfa, MembershipOracle<I, Boolean> delegate) {
        this.incDfa = incDfa;
        this.incDfaLock = new ReentrantReadWriteLock();
        this.delegate = delegate;
    }

    public static <I> DFACacheOracle<I> createTreeCacheOracle(Alphabet<I> alphabet, MembershipOracle<I, Boolean> delegate) {
        return new DFACacheOracle<I>(new IncrementalDFATreeBuilder(alphabet), delegate);
    }

    public static <I> DFACacheOracle<I> createTreePCCacheOracle(Alphabet<I> alphabet, MembershipOracle<I, Boolean> delegate) {
        return new DFACacheOracle<I>(new IncrementalPCDFATreeBuilder(alphabet), delegate);
    }

    public static <I> DFACacheOracle<I> createDAGCacheOracle(Alphabet<I> alphabet, MembershipOracle<I, Boolean> delegate) {
        return new DFACacheOracle<I>(new IncrementalDFADAGBuilder(alphabet), delegate);
    }

    public static <I> DFACacheOracle<I> createDAGPCCacheOracle(Alphabet<I> alphabet, MembershipOracle<I, Boolean> delegate) {
        return new DFACacheOracle<I>(new IncrementalPCDFADAGBuilder(alphabet), delegate);
    }

    public DFACacheConsistencyTest<I> createCacheConsistencyTest() {
        return new DFACacheConsistencyTest<I>(this.incDfa, this.incDfaLock);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processQueries(Collection<? extends Query<I, Boolean>> queries) {
        ArrayList<ProxyQuery<I>> unanswered = new ArrayList<ProxyQuery<I>>();
        this.incDfaLock.readLock().lock();
        try {
            for (Query<I, Boolean> query : queries) {
                Acceptance acc = this.incDfa.lookup(query.getInput());
                if (acc != Acceptance.DONT_KNOW) {
                    query.answer((Object)acc.toBoolean());
                    continue;
                }
                unanswered.add(new ProxyQuery<I>(query));
            }
        }
        finally {
            this.incDfaLock.readLock().unlock();
        }
        this.delegate.processQueries(unanswered);
        this.incDfaLock.writeLock().lock();
        try {
            for (ProxyQuery proxyQuery : unanswered) {
                this.incDfa.insert(proxyQuery.getInput(), proxyQuery.getAnswer().booleanValue());
            }
        }
        finally {
            this.incDfaLock.writeLock().unlock();
        }
    }

    public void addAlphabetSymbol(I symbol) {
        this.incDfa.addAlphabetSymbol(symbol);
    }

    public DFACacheOracleState<I> suspend() {
        return new DFACacheOracleState<I>(this.incDfa);
    }

    public void resume(DFACacheOracleState<I> state) {
        Class<?> stateClass;
        Class<?> thisClass = this.incDfa.getClass();
        if (!thisClass.equals(stateClass = state.getBuilder().getClass())) {
            LOGGER.warn("You currently plan to use a '{}', but the state contained a '{}'. This may yield unexpected behavior.", thisClass, stateClass);
        }
        this.incDfa = state.getBuilder();
    }

    public static class DFACacheOracleState<I>
    implements Serializable {
        private final IncrementalDFABuilder<I> builder;

        DFACacheOracleState(IncrementalDFABuilder<I> builder) {
            this.builder = builder;
        }

        IncrementalDFABuilder<I> getBuilder() {
            return this.builder;
        }
    }
}

