/*
 * Decompiled with CFR 0.152.
 */
package de.learnlib.filter.cache.sul;

import de.learnlib.api.Resumable;
import de.learnlib.api.StateLocalInputSUL;
import de.learnlib.filter.cache.sul.AbstractSULCache;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import net.automatalib.incremental.mealy.IncrementalMealyBuilder;
import net.automatalib.incremental.mealy.tree.IncrementalMealyTreeBuilder;
import net.automatalib.ts.output.MealyTransitionSystem;
import net.automatalib.words.Alphabet;

public class StateLocalInputSULCache<I, O>
extends AbstractSULCache<I, O>
implements StateLocalInputSUL<I, O>,
Resumable<StateLocalInputSULCacheState<I, O>> {
    private final StateLocalInputSULCacheImpl<?, I, ?, O> impl;

    StateLocalInputSULCache(IncrementalMealyBuilder<I, O> incMealy, StateLocalInputSUL<I, O> sul) {
        this(new StateLocalInputSULCacheImpl(incMealy, (ReadWriteLock)new ReentrantReadWriteLock(), incMealy.asTransitionSystem(), sul));
    }

    private <S, T> StateLocalInputSULCache(StateLocalInputSULCacheImpl<S, I, T, O> cacheImpl) {
        super(cacheImpl);
        this.impl = cacheImpl;
    }

    public static <I, O> StateLocalInputSULCache<I, O> createTreeCache(Alphabet<I> alphabet, StateLocalInputSUL<I, O> sul) {
        return new StateLocalInputSULCache<I, O>(new IncrementalMealyTreeBuilder(alphabet), sul);
    }

    @Override
    public StateLocalInputSUL<I, O> fork() {
        return this.impl.fork();
    }

    public Collection<I> currentlyEnabledInputs() {
        return this.impl.currentlyEnabledInputs();
    }

    public StateLocalInputSULCacheState<I, O> suspend() {
        return this.impl.suspend();
    }

    public void resume(StateLocalInputSULCacheState<I, O> state) {
        this.impl.resume(state);
    }

    public static final class StateLocalInputSULCacheState<I, O>
    extends AbstractSULCache.AbstractSULCacheState<I, O> {
        final Map<?, Collection<I>> enabledInputCache;

        StateLocalInputSULCacheState(IncrementalMealyBuilder<I, O> builder, Map<?, Collection<I>> enabledInputCache) {
            super(builder);
            this.enabledInputCache = enabledInputCache;
        }
    }

    private static final class StateLocalInputSULCacheImpl<S, I, T, O>
    extends AbstractSULCache.AbstractSULCacheImpl<S, I, T, O, StateLocalInputSULCacheState<I, O>>
    implements StateLocalInputSUL<I, O> {
        private final StateLocalInputSUL<I, O> delegate;
        private S initialState;
        private Map<S, Collection<I>> enabledInputCache;
        private final List<Collection<I>> inputsTrace;

        StateLocalInputSULCacheImpl(IncrementalMealyBuilder<I, O> incMealy, ReadWriteLock lock, MealyTransitionSystem<S, I, T, O> mealyTs, StateLocalInputSUL<I, O> sul) {
            this(incMealy, lock, mealyTs, new HashMap(), sul);
        }

        private StateLocalInputSULCacheImpl(IncrementalMealyBuilder<I, O> incMealy, ReadWriteLock lock, MealyTransitionSystem<S, I, T, O> mealyTs, Map<S, Collection<I>> enabledInputCache, StateLocalInputSUL<I, O> sul) {
            super(incMealy, lock, mealyTs, sul);
            this.delegate = sul;
            this.enabledInputCache = enabledInputCache;
            this.initialState = mealyTs.getInitialState();
            this.inputsTrace = new ArrayList<Collection<I>>();
        }

        @Override
        protected void postNewStepHook() {
            this.inputsTrace.add(this.delegate.currentlyEnabledInputs());
        }

        @Override
        protected void postCacheWriteHook(List<I> input) {
            int prefixLength = input.size() - this.inputsTrace.size();
            Object iter = this.mealyTs.getSuccessor(this.initialState, input.subList(0, prefixLength));
            for (int i = 0; i < this.inputsTrace.size(); ++i) {
                iter = this.mealyTs.getSuccessor(iter, input.get(i + prefixLength));
                this.enabledInputCache.put(iter, this.inputsTrace.get(i));
            }
            this.inputsTrace.clear();
        }

        public Collection<I> currentlyEnabledInputs() {
            if (this.current == this.initialState) {
                Collection initialInputs = this.enabledInputCache.get(this.initialState);
                if (initialInputs == null) {
                    super.requiredInitializedDelegate();
                    initialInputs = this.delegate.currentlyEnabledInputs();
                    this.enabledInputCache.put(this.initialState, initialInputs);
                }
                return initialInputs;
            }
            Collection<I> inputs = this.enabledInputCache.get(this.current);
            if (inputs != null) {
                return inputs;
            }
            return this.inputsTrace.get(this.inputsTrace.size() - 1);
        }

        public StateLocalInputSUL<I, O> fork() {
            return new StateLocalInputSULCacheImpl<S, I, T, O>(this.incMealy, this.incMealyLock, this.mealyTs, this.enabledInputCache, this.delegate.fork());
        }

        public StateLocalInputSULCacheState<I, O> suspend() {
            return new StateLocalInputSULCacheState(this.incMealy, this.enabledInputCache);
        }

        @Override
        public void resume(StateLocalInputSULCacheState<I, O> state) {
            super.resume(state);
            this.initialState = this.mealyTs.getInitialState();
            this.enabledInputCache = state.enabledInputCache;
        }
    }
}

