/*
 * Decompiled with CFR 0.152.
 */
package de.learnlib.cache.dfa;

import de.learnlib.api.EquivalenceOracle;
import de.learnlib.api.MembershipOracle;
import de.learnlib.api.Query;
import de.learnlib.cache.LearningCacheOracle;
import de.learnlib.cache.dfa.DFAHashCacheConsistencyTest;
import de.learnlib.cache.dfa.ProxyQuery;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import net.automatalib.automata.fsa.DFA;
import net.automatalib.words.Word;

public class DFAHashCacheOracle<I>
implements LearningCacheOracle.DFALearningCacheOracle<I> {
    private final MembershipOracle<I, Boolean> delegate;
    private final Map<Word<I>, Boolean> cache;
    private final Lock cacheLock;

    public DFAHashCacheOracle(MembershipOracle<I, Boolean> delegate) {
        this.delegate = delegate;
        this.cache = new HashMap<Word<I>, Boolean>();
        this.cacheLock = new ReentrantLock();
    }

    @Override
    public EquivalenceOracle<DFA<?, I>, I, Boolean> createCacheConsistencyTest() {
        return new DFAHashCacheConsistencyTest<I>(this.cache, this.cacheLock);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processQueries(Collection<? extends Query<I, Boolean>> queries) {
        ArrayList<ProxyQuery<I>> misses = new ArrayList<ProxyQuery<I>>();
        this.cacheLock.lock();
        try {
            for (Query<I, Boolean> query : queries) {
                Word input = query.getInput();
                Boolean answer = this.cache.get(input);
                if (answer != null) {
                    query.answer((Object)answer);
                    continue;
                }
                misses.add(new ProxyQuery<I>(query));
            }
        }
        finally {
            this.cacheLock.unlock();
        }
        this.delegate.processQueries(misses);
        this.cacheLock.lock();
        try {
            for (ProxyQuery proxyQuery : misses) {
                this.cache.put(proxyQuery.getInput(), proxyQuery.getAnswer());
            }
        }
        finally {
            this.cacheLock.unlock();
        }
    }
}

