/*
 * Decompiled with CFR 0.152.
 */
package de.learnlib.cache.dfa;

import de.learnlib.api.MembershipOracle;
import de.learnlib.api.Query;
import de.learnlib.cache.LearningCacheOracle;
import de.learnlib.cache.dfa.DFACacheConsistencyTest;
import de.learnlib.cache.dfa.ProxyQuery;
import java.util.ArrayList;
import java.util.Collection;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import javax.annotation.ParametersAreNonnullByDefault;
import net.automatalib.incremental.dfa.Acceptance;
import net.automatalib.incremental.dfa.IncrementalDFABuilder;
import net.automatalib.incremental.dfa.dag.IncrementalDFADAGBuilder;
import net.automatalib.incremental.dfa.tree.IncrementalDFATreeBuilder;
import net.automatalib.words.Alphabet;

@ParametersAreNonnullByDefault
public class DFACacheOracle<I>
implements LearningCacheOracle.DFALearningCacheOracle<I> {
    private final IncrementalDFABuilder<I> incDfa;
    private final Lock incDfaLock;
    private final MembershipOracle<I, Boolean> delegate;

    public static <I> DFACacheOracle<I> createTreeCacheOracle(Alphabet<I> alphabet, MembershipOracle<I, Boolean> delegate) {
        return new DFACacheOracle<I>(new IncrementalDFATreeBuilder(alphabet), delegate);
    }

    public static <I> DFACacheOracle<I> createDAGCacheOracle(Alphabet<I> alphabet, MembershipOracle<I, Boolean> delegate) {
        return new DFACacheOracle<I>(new IncrementalDFADAGBuilder(alphabet), delegate);
    }

    @Deprecated
    public DFACacheOracle(Alphabet<I> alphabet, MembershipOracle<I, Boolean> delegate) {
        this((IncrementalDFABuilder<I>)new IncrementalDFADAGBuilder(alphabet), delegate);
    }

    public DFACacheOracle(IncrementalDFABuilder<I> incDfa, MembershipOracle<I, Boolean> delegate) {
        this(incDfa, new ReentrantLock(), delegate);
    }

    private DFACacheOracle(IncrementalDFABuilder<I> incDfa, Lock lock, MembershipOracle<I, Boolean> delegate) {
        this.incDfa = incDfa;
        this.incDfaLock = lock;
        this.delegate = delegate;
    }

    public DFACacheConsistencyTest<I> createCacheConsistencyTest() {
        return new DFACacheConsistencyTest<I>(this.incDfa, this.incDfaLock);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processQueries(Collection<? extends Query<I, Boolean>> queries) {
        ArrayList<ProxyQuery<I>> unanswered = new ArrayList<ProxyQuery<I>>();
        this.incDfaLock.lock();
        try {
            for (Query<I, Boolean> query : queries) {
                Acceptance acc = this.incDfa.lookup(query.getInput());
                if (acc != Acceptance.DONT_KNOW) {
                    query.answer((Object)acc.toBoolean());
                    continue;
                }
                unanswered.add(new ProxyQuery<I>(query));
            }
        }
        finally {
            this.incDfaLock.unlock();
        }
        this.delegate.processQueries(unanswered);
        this.incDfaLock.lock();
        try {
            for (ProxyQuery proxyQuery : unanswered) {
                this.incDfa.insert(proxyQuery.getInput(), proxyQuery.getAnswer().booleanValue());
            }
        }
        finally {
            this.incDfaLock.unlock();
        }
    }
}

