/*
 * Decompiled with CFR 0.152.
 */
package de.learnlib.cache.sul;

import de.learnlib.api.SUL;
import de.learnlib.cache.LearningCache;
import de.learnlib.cache.mealy.MealyCacheConsistencyTest;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.automatalib.incremental.mealy.IncrementalMealyBuilder;
import net.automatalib.incremental.mealy.dag.IncrementalMealyDAGBuilder;
import net.automatalib.incremental.mealy.tree.IncrementalMealyTreeBuilder;
import net.automatalib.ts.transout.MealyTransitionSystem;
import net.automatalib.words.Alphabet;
import net.automatalib.words.WordBuilder;

@ParametersAreNonnullByDefault
public class SULCache<I, O>
implements SUL<I, O>,
LearningCache.MealyLearningCache<I, O> {
    private final SULCacheImpl<?, I, ?, O> impl;

    public static <I, O> SULCache<I, O> createTreeCache(Alphabet<I> alphabet, SUL<I, O> sul) {
        return new SULCache<I, O>(new IncrementalMealyTreeBuilder(alphabet), sul);
    }

    public static <I, O> SULCache<I, O> createDAGCache(Alphabet<I> alphabet, SUL<I, O> sul) {
        return new SULCache<I, O>(new IncrementalMealyDAGBuilder(alphabet), sul);
    }

    @Deprecated
    public SULCache(Alphabet<I> alphabet, SUL<I, O> sul) {
        this((IncrementalMealyBuilder<I, O>)new IncrementalMealyDAGBuilder(alphabet), sul);
    }

    public SULCache(IncrementalMealyBuilder<I, O> incMealy, SUL<I, O> sul) {
        this(incMealy, new ReentrantLock(), sul);
    }

    public SULCache(IncrementalMealyBuilder<I, O> incMealy, Lock lock, SUL<I, O> sul) {
        this.impl = new SULCacheImpl(incMealy, lock, incMealy.asTransitionSystem(), sul);
    }

    public void pre() {
        this.impl.pre();
    }

    public O step(I in) {
        return this.impl.step(in);
    }

    public MealyCacheConsistencyTest<I, O> createCacheConsistencyTest() {
        return this.impl.createCacheConsistencyTest();
    }

    public void post() {
        this.impl.post();
    }

    @ParametersAreNonnullByDefault
    private static final class SULCacheImpl<S, I, T, O> {
        private final IncrementalMealyBuilder<I, O> incMealy;
        private final MealyTransitionSystem<S, I, T, O> mealyTs;
        private final SUL<I, O> delegate;
        private S current;
        private final WordBuilder<I> inputWord = new WordBuilder();
        private WordBuilder<O> outputWord;
        private final Lock incMealyLock;

        public SULCacheImpl(IncrementalMealyBuilder<I, O> incMealy, Lock lock, MealyTransitionSystem<S, I, T, O> mealyTs, SUL<I, O> sul) {
            this.incMealy = incMealy;
            this.mealyTs = mealyTs;
            this.delegate = sul;
            this.incMealyLock = lock;
        }

        public void pre() {
            this.incMealyLock.lock();
            this.current = this.mealyTs.getInitialState();
        }

        @Nullable
        public O step(@Nullable I in) {
            Object out = null;
            if (this.current != null) {
                Object trans = this.mealyTs.getTransition(this.current, in);
                if (trans != null) {
                    out = this.mealyTs.getTransitionOutput(trans);
                    this.current = this.mealyTs.getSuccessor(trans);
                    assert (this.current != null);
                } else {
                    this.incMealyLock.unlock();
                    this.current = null;
                    this.outputWord = new WordBuilder();
                    this.delegate.pre();
                    for (Object prevSym : this.inputWord) {
                        this.outputWord.append(this.delegate.step(prevSym));
                    }
                }
            }
            this.inputWord.append(in);
            if (this.current == null) {
                out = this.delegate.step(in);
                this.outputWord.add(out);
            }
            return (O)out;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void post() {
            try {
                if (this.outputWord != null) {
                    this.incMealyLock.lock();
                    this.incMealy.insert(this.inputWord.toWord(), this.outputWord.toWord());
                }
            }
            finally {
                this.incMealyLock.unlock();
            }
            this.inputWord.clear();
            this.outputWord = null;
            this.current = null;
        }

        @Nonnull
        public MealyCacheConsistencyTest<I, O> createCacheConsistencyTest() {
            return new MealyCacheConsistencyTest<I, O>(this.incMealy, this.incMealyLock);
        }
    }
}

