/*
 * Decompiled with CFR 0.152.
 */
package de.learnlib.cache.mealy;

import de.learnlib.api.MembershipOracle;
import de.learnlib.api.Query;
import de.learnlib.cache.LearningCacheOracle;
import de.learnlib.cache.mealy.MasterQuery;
import de.learnlib.cache.mealy.MealyCacheConsistencyTest;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import net.automatalib.commons.util.comparison.CmpUtil;
import net.automatalib.commons.util.mappings.Mapping;
import net.automatalib.incremental.mealy.IncrementalMealyBuilder;
import net.automatalib.incremental.mealy.dag.IncrementalMealyDAGBuilder;
import net.automatalib.incremental.mealy.tree.IncrementalMealyTreeBuilder;
import net.automatalib.words.Alphabet;
import net.automatalib.words.Word;
import net.automatalib.words.WordBuilder;

public class MealyCacheOracle<I, O>
implements LearningCacheOracle.MealyLearningCacheOracle<I, O> {
    private final MembershipOracle<I, Word<O>> delegate;
    private final IncrementalMealyBuilder<I, O> incMealy;
    private final Lock incMealyLock;
    private final Comparator<? super Query<I, ?>> queryCmp;
    private final Mapping<? super O, ? extends O> errorSyms;

    public static <I, O> MealyCacheOracle<I, O> createDAGCacheOracle(Alphabet<I> inputAlphabet, MembershipOracle<I, Word<O>> delegate) {
        return MealyCacheOracle.createDAGCacheOracle(inputAlphabet, null, delegate);
    }

    public static <I, O> MealyCacheOracle<I, O> createDAGCacheOracle(Alphabet<I> inputAlphabet, Mapping<? super O, ? extends O> errorSyms, MembershipOracle<I, Word<O>> delegate) {
        IncrementalMealyDAGBuilder incrementalBuilder = new IncrementalMealyDAGBuilder(inputAlphabet);
        return new MealyCacheOracle<I, O>(incrementalBuilder, errorSyms, delegate);
    }

    public static <I, O> MealyCacheOracle<I, O> createTreeCacheOracle(Alphabet<I> inputAlphabet, MembershipOracle<I, Word<O>> delegate) {
        return MealyCacheOracle.createTreeCacheOracle(inputAlphabet, null, delegate);
    }

    public static <I, O> MealyCacheOracle<I, O> createTreeCacheOracle(Alphabet<I> inputAlphabet, Mapping<? super O, ? extends O> errorSyms, MembershipOracle<I, Word<O>> delegate) {
        IncrementalMealyTreeBuilder incrementalBuilder = new IncrementalMealyTreeBuilder(inputAlphabet);
        return new MealyCacheOracle<I, O>(incrementalBuilder, errorSyms, delegate);
    }

    public MealyCacheOracle(IncrementalMealyBuilder<I, O> incrementalBuilder, Mapping<? super O, ? extends O> errorSyms, MembershipOracle<I, Word<O>> delegate) {
        this(incrementalBuilder, new ReentrantLock(), errorSyms, delegate);
    }

    public MealyCacheOracle(IncrementalMealyBuilder<I, O> incrementalBuilder, Lock lock, Mapping<? super O, ? extends O> errorSyms, MembershipOracle<I, Word<O>> delegate) {
        this.incMealy = incrementalBuilder;
        this.incMealyLock = lock;
        this.queryCmp = new ReverseLexCmp(incrementalBuilder.getInputAlphabet());
        this.errorSyms = errorSyms;
        this.delegate = delegate;
    }

    @Deprecated
    public MealyCacheOracle(Alphabet<I> alphabet, MembershipOracle<I, Word<O>> delegate) {
        this(alphabet, null, delegate);
    }

    @Deprecated
    public MealyCacheOracle(Alphabet<I> alphabet, Mapping<? super O, ? extends O> errorSyms, MembershipOracle<I, Word<O>> delegate) {
        this((IncrementalMealyBuilder<I, ? extends O>)new IncrementalMealyDAGBuilder(alphabet), (Mapping<? extends O, ? extends O>)errorSyms, (MembershipOracle<I, Word<? extends O>>)delegate);
    }

    public int getCacheSize() {
        return this.incMealy.asGraph().size();
    }

    public MealyCacheConsistencyTest<I, O> createCacheConsistencyTest() {
        return new MealyCacheConsistencyTest<I, O>(this.incMealy, this.incMealyLock);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processQueries(Collection<? extends Query<I, Word<O>>> queries) {
        if (queries.isEmpty()) {
            return;
        }
        ArrayList<Query<I, Word<O>>> qrys = new ArrayList<Query<I, Word<O>>>(queries);
        Collections.sort(qrys, this.queryCmp);
        ArrayList<MasterQuery<I, O>> masterQueries = new ArrayList<MasterQuery<I, O>>();
        Iterator it = qrys.iterator();
        Query q = (Query)it.next();
        Word ref = q.getInput();
        this.incMealyLock.lock();
        try {
            MasterQuery<I, O> master = this.createMasterQuery(ref);
            if (!master.isAnswered()) {
                masterQueries.add(master);
            }
            master.addSlave(q);
            while (it.hasNext()) {
                q = (Query)it.next();
                Word word = q.getInput();
                if (!word.isPrefixOf(ref) && !(master = this.createMasterQuery(word)).isAnswered()) {
                    masterQueries.add(master);
                }
                master.addSlave(q);
                ref = word;
            }
        }
        finally {
            this.incMealyLock.unlock();
        }
        this.delegate.processQueries(masterQueries);
        this.incMealyLock.lock();
        try {
            for (MasterQuery masterQuery : masterQueries) {
                this.postProcess(masterQuery);
            }
        }
        finally {
            this.incMealyLock.unlock();
        }
    }

    private void postProcess(MasterQuery<I, O> master) {
        Object sym;
        Word word = master.getSuffix();
        Word<O> answer = master.getAnswer();
        if (this.errorSyms == null) {
            this.incMealy.insert(word, answer);
            return;
        }
        int answLen = answer.length();
        int i = 0;
        while (i < answLen && this.errorSyms.get(sym = answer.getSymbol(i++)) == null) {
        }
        if (i == answLen) {
            this.incMealy.insert(word, answer);
        } else {
            this.incMealy.insert(word.prefix(i), answer.prefix(i));
        }
    }

    private MasterQuery<I, O> createMasterQuery(Word<I> word) {
        Object repSym;
        WordBuilder wb = new WordBuilder();
        if (this.incMealy.lookup(word, (List)wb)) {
            return new MasterQuery(word, wb.toWord());
        }
        if (this.errorSyms == null) {
            return new MasterQuery(word);
        }
        int wbSize = wb.size();
        if (wbSize == 0 || (repSym = this.errorSyms.get(wb.getSymbol(wbSize - 1))) == null) {
            return new MasterQuery<I, O>(word, this.errorSyms);
        }
        wb.repeatAppend(word.length() - wbSize, repSym);
        return new MasterQuery(word, wb.toWord());
    }

    private static final class ReverseLexCmp<I>
    implements Comparator<Query<I, ?>> {
        private final Alphabet<I> alphabet;

        public ReverseLexCmp(Alphabet<I> alphabet) {
            this.alphabet = alphabet;
        }

        @Override
        public int compare(Query<I, ?> o1, Query<I, ?> o2) {
            return -CmpUtil.lexCompare((Iterable)o1.getInput(), (Iterable)o2.getInput(), this.alphabet);
        }
    }
}

