/*
 * Decompiled with CFR 0.152.
 */
package de.learnlib.cache.mealy;

import de.learnlib.api.Query;
import de.learnlib.oracles.AbstractQuery;
import java.util.ArrayList;
import java.util.List;
import net.automatalib.commons.util.mappings.Mapping;
import net.automatalib.words.Word;
import net.automatalib.words.WordBuilder;

final class MasterQuery<I, O>
extends AbstractQuery<I, Word<O>> {
    private Word<O> answer;
    private final Mapping<? super O, ? extends O> errorSyms;
    private final List<Query<I, Word<O>>> slaves;

    public MasterQuery(Word<I> word) {
        this(word, (Mapping)null);
    }

    public MasterQuery(Word<I> word, Word<O> output) {
        super(word);
        this.answer = output;
        this.errorSyms = null;
        this.slaves = null;
    }

    public MasterQuery(Word<I> word, Mapping<? super O, ? extends O> errorSyms) {
        super(word);
        this.errorSyms = errorSyms;
        this.slaves = new ArrayList<Query<I, Word<O>>>();
    }

    public Word<O> getAnswer() {
        return this.answer;
    }

    public boolean isAnswered() {
        return this.answer != null;
    }

    public void answer(Word<O> output) {
        output = this.truncateOutput(output);
        this.answer = output;
        for (Query<I, Word<O>> slave : this.slaves) {
            this.answerSlave(slave);
        }
    }

    public void addSlave(Query<I, Word<O>> slave) {
        if (this.slaves == null) {
            this.answerSlave(slave);
        } else {
            this.slaves.add(slave);
        }
    }

    private void answerSlave(Query<I, Word<O>> slave) {
        int start = slave.getPrefix().length();
        int end = start + slave.getSuffix().length();
        slave.answer((Object)this.answer.subWord(start, end));
    }

    private Word<O> truncateOutput(Word<O> output) {
        if (this.errorSyms == null) {
            return output;
        }
        int maxLen = output.length() - 1;
        int i = 0;
        Object repSym = null;
        while (i < maxLen && repSym == null) {
            Object sym = output.getSymbol(i++);
            repSym = this.errorSyms.get(sym);
        }
        if (repSym == null) {
            return output;
        }
        WordBuilder wb = new WordBuilder(maxLen + 1);
        wb.append(output.prefix(i));
        wb.repeatAppend(1 + maxLen - i, repSym);
        return wb.toWord();
    }

    public String toString() {
        return this.toStringWithAnswer(this.answer);
    }
}

