/*
 * Decompiled with CFR 0.152.
 */
package de.learnlib.cache.dfa;

import de.learnlib.api.EquivalenceOracle;
import de.learnlib.oracles.DefaultQuery;
import java.util.Collection;
import java.util.Map;
import java.util.concurrent.locks.Lock;
import net.automatalib.automata.fsa.DFA;
import net.automatalib.words.Word;

final class DFAHashCacheConsistencyTest<I>
implements EquivalenceOracle.DFAEquivalenceOracle<I> {
    private final Map<Word<I>, Boolean> cache;
    private final Lock cacheLock;

    public DFAHashCacheConsistencyTest(Map<Word<I>, Boolean> cache, Lock cacheLock) {
        this.cache = cache;
        this.cacheLock = cacheLock;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DefaultQuery<I, Boolean> findCounterExample(DFA<?, I> hypothesis, Collection<? extends I> inputs) {
        this.cacheLock.lock();
        try {
            for (Map.Entry<Word<I>, Boolean> cacheEntry : this.cache.entrySet()) {
                Word<I> input = cacheEntry.getKey();
                Boolean answer = cacheEntry.getValue();
                if (((Boolean)hypothesis.computeOutput(input)).equals(answer)) continue;
                DefaultQuery defaultQuery = new DefaultQuery(input, (Object)answer);
                return defaultQuery;
            }
            DefaultQuery<I, Boolean> defaultQuery = null;
            return defaultQuery;
        }
        finally {
            this.cacheLock.unlock();
        }
    }
}

