/*
 * Decompiled with CFR 0.152.
 */
package de.learnlib.api.oracle;

import de.learnlib.api.query.DefaultQuery;
import de.learnlib.api.query.OmegaQuery;
import java.util.Collection;
import net.automatalib.automata.concepts.Output;
import net.automatalib.modelchecking.Lasso;
import net.automatalib.words.Word;
import org.checkerframework.checker.nullness.qual.Nullable;

public interface LassoOracle<L extends Lasso<I, D>, I, D> {
    public OmegaQuery<I, D> processInput(Word<I> var1, Word<I> var2, int var3);

    public boolean isCounterExample(Output<I, D> var1, Iterable<? extends I> var2, D var3);

    default public @Nullable DefaultQuery<I, D> findCounterExample(L hypothesis, Collection<? extends I> inputs) {
        int repeat;
        Word loop;
        Word prefix = hypothesis.getPrefix();
        OmegaQuery<I, D> omegaQuery = this.processInput(prefix, loop = hypothesis.getLoop(), repeat = hypothesis.getUnfolds());
        if (omegaQuery.isUltimatelyPeriodic()) {
            DefaultQuery<I, D> ce = omegaQuery.asDefaultQuery();
            if (this.isCounterExample((Output<I, D>)hypothesis.getAutomaton(), (Iterable<? extends I>)ce.getInput(), ce.getOutput())) {
                return ce;
            }
        }
        return null;
    }

    public static interface MealyLassoOracle<I, O>
    extends LassoOracle<Lasso.MealyLasso<I, O>, I, Word<O>> {
    }

    public static interface DFALassoOracle<I>
    extends LassoOracle<Lasso.DFALasso<I>, I, Boolean> {
    }
}

