/*
 * Decompiled with CFR 0.152.
 */
package de.learnlib.api.logging;

import de.learnlib.api.logging.LearnLogger;
import de.learnlib.api.oracle.PropertyOracle;
import de.learnlib.api.query.DefaultQuery;
import java.util.Collection;
import net.automatalib.automata.concepts.Output;
import net.automatalib.automata.fsa.DFA;
import net.automatalib.automata.transducers.MealyMachine;
import net.automatalib.words.Word;
import org.checkerframework.checker.nullness.qual.Nullable;

public class LoggingPropertyOracle<I, A extends Output<I, D>, P, D>
implements PropertyOracle<I, A, P, D> {
    private static final LearnLogger LOGGER = LearnLogger.getLogger(LoggingPropertyOracle.class);
    private final PropertyOracle<I, A, P, D> propertyOracle;

    public LoggingPropertyOracle(PropertyOracle<I, A, P, D> propertyOracle) {
        this.propertyOracle = propertyOracle;
    }

    @Override
    public boolean isDisproved() {
        return this.propertyOracle.isDisproved();
    }

    @Override
    public void setProperty(P property) {
        this.propertyOracle.setProperty(property);
    }

    @Override
    public P getProperty() {
        return this.propertyOracle.getProperty();
    }

    @Override
    public @Nullable DefaultQuery<I, D> getCounterExample() {
        return this.propertyOracle.getCounterExample();
    }

    @Override
    public @Nullable DefaultQuery<I, D> disprove(A hypothesis, Collection<? extends I> inputs) {
        DefaultQuery<? extends I, D> result = this.propertyOracle.disprove(hypothesis, inputs);
        if (result != null) {
            LOGGER.logEvent("Property violated: '" + this.toString() + "'");
            LOGGER.logQuery("Counter example for property: " + this.getCounterExample());
        }
        return result;
    }

    @Override
    public @Nullable DefaultQuery<I, D> doFindCounterExample(A hypothesis, Collection<? extends I> inputs) {
        DefaultQuery<? extends I, D> result = this.propertyOracle.findCounterExample(hypothesis, inputs);
        if (result != null) {
            LOGGER.logEvent("Spurious counterexample found for property: '" + this.toString() + "'");
            LOGGER.logCounterexample("Spurious counterexample: " + result);
        }
        return result;
    }

    public String toString() {
        return String.valueOf(this.propertyOracle.getProperty());
    }

    public static class MealyLoggingPropertyOracle<I, O, P>
    extends LoggingPropertyOracle<I, MealyMachine<?, I, ?, O>, P, Word<O>>
    implements PropertyOracle.MealyPropertyOracle<I, O, P> {
        public MealyLoggingPropertyOracle(PropertyOracle.MealyPropertyOracle<I, O, P> property) {
            super(property);
        }
    }

    public static class DFALoggingPropertyOracle<I, P>
    extends LoggingPropertyOracle<I, DFA<?, I>, P, Boolean>
    implements PropertyOracle.DFAPropertyOracle<I, P> {
        public DFALoggingPropertyOracle(PropertyOracle.DFAPropertyOracle<I, P> property) {
            super(property);
        }
    }
}

