/*
 * Decompiled with CFR 0.152.
 */
package de.learnlib.api.logging;

import de.learnlib.api.logging.Category;
import de.learnlib.api.logging.Slf4jDelegator;
import de.learnlib.api.statistic.StatisticData;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.Marker;
import org.slf4j.MarkerFactory;

public interface LearnLogger
extends Logger {
    public static LearnLogger getLogger(Class<?> clazz) {
        return LearnLogger.getLogger(clazz.getName());
    }

    public static LearnLogger getLogger(String name) {
        return new Slf4jDelegator(LoggerFactory.getLogger((String)name));
    }

    default public void logSystem(String msg) {
        Marker marker = MarkerFactory.getMarker((String)Category.SYSTEM.toMarkerLabel());
        this.info(marker, msg);
    }

    default public void logPhase(String phase) {
        Marker marker = MarkerFactory.getMarker((String)Category.PHASE.toMarkerLabel());
        this.info(marker, phase);
    }

    default public void logQuery(String phase) {
        Marker marker = MarkerFactory.getMarker((String)Category.QUERY.toMarkerLabel());
        this.info(marker, phase);
    }

    default public void logConfig(String config) {
        Marker marker = MarkerFactory.getMarker((String)Category.CONFIG.toMarkerLabel());
        this.info(marker, config);
    }

    default public void logCounterexample(String ce) {
        Marker marker = MarkerFactory.getMarker((String)Category.COUNTEREXAMPLE.toMarkerLabel());
        this.info(marker, ce);
    }

    default public void logEvent(String desc) {
        Marker marker = MarkerFactory.getMarker((String)Category.EVENT.toMarkerLabel());
        this.info(marker, desc);
    }

    default public void logProfilingInfo(StatisticData profiling) {
        Marker marker = MarkerFactory.getMarker((String)Category.PROFILING.toMarkerLabel());
        this.info(marker, profiling.getSummary());
    }

    default public void logStatistic(StatisticData statistics) {
        Marker marker = MarkerFactory.getMarker((String)Category.STATISTIC.toMarkerLabel());
        this.info(marker, statistics.getSummary());
    }

    default public void logModel(Object o) {
        Marker marker = MarkerFactory.getMarker((String)Category.MODEL.toMarkerLabel());
        this.info(marker, o.toString());
    }

    default public void logDataStructure(Object o) {
        Marker marker = MarkerFactory.getMarker((String)Category.DATASTRUCTURE.toMarkerLabel());
        this.info(marker, o.toString());
    }
}

