/*
 * Decompiled with CFR 0.152.
 */
package de.learnlib.api.algorithm;

import de.learnlib.api.query.DefaultQuery;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import net.automatalib.automata.fsa.DFA;
import net.automatalib.automata.fsa.FiniteStateAcceptor;
import net.automatalib.automata.fsa.NFA;
import net.automatalib.automata.transducers.MealyMachine;
import net.automatalib.words.Word;

public interface PassiveLearningAlgorithm<M, I, D> {
    public void addSamples(Collection<? extends DefaultQuery<I, D>> var1);

    default public void addSamples(DefaultQuery<I, D> ... samples) {
        this.addSamples(Arrays.asList(samples));
    }

    default public void addSamples(D output, Word<I> ... words) {
        this.addSamples(output, Arrays.asList(words));
    }

    default public void addSamples(D output, Collection<? extends Word<I>> words) {
        ArrayList<DefaultQuery<I, D>> queries = new ArrayList<DefaultQuery<I, D>>(words.size());
        for (Word<I> word : words) {
            queries.add(new DefaultQuery<I, D>(word, output));
        }
        this.addSamples(queries);
    }

    default public void addSample(Word<I> input, D output) {
        this.addSample(new DefaultQuery<I, D>(input, output));
    }

    default public void addSample(DefaultQuery<I, D> sample) {
        this.addSamples(Collections.singleton(sample));
    }

    public M computeModel();

    public static interface PassiveAcceptorLearner<M extends FiniteStateAcceptor<?, I>, I>
    extends PassiveLearningAlgorithm<M, I, Boolean> {
        default public void addPositiveSample(Word<I> word) {
            this.addSample(word, true);
        }

        default public void addPositiveSamples(Collection<? extends Word<I>> words) {
            this.addSamples(Boolean.valueOf(true), words);
        }

        default public void addPositiveSamples(Word<I> ... words) {
            this.addSamples(Boolean.valueOf(true), words);
        }

        default public void addNegativeSample(Word<I> word) {
            this.addSample(word, false);
        }

        default public void addNegativeSamples(Collection<? extends Word<I>> words) {
            this.addSamples(Boolean.valueOf(false), words);
        }

        default public void addNegativeSamples(Word<I> ... words) {
            this.addSamples(Boolean.valueOf(false), words);
        }
    }

    public static interface PassiveNFALearner<I>
    extends PassiveAcceptorLearner<NFA<?, I>, I> {
    }

    public static interface PassiveMealyLearner<I, O>
    extends PassiveLearningAlgorithm<MealyMachine<?, I, ?, O>, I, Word<O>> {
    }

    public static interface PassiveDFALearner<I>
    extends PassiveAcceptorLearner<DFA<?, I>, I> {
    }
}

