/*
 * Decompiled with CFR 0.152.
 */
package de.learnlib.algorithm.adt.util;

import de.learnlib.algorithm.adt.adt.ADTLeafNode;
import de.learnlib.algorithm.adt.adt.ADTNode;
import de.learnlib.algorithm.adt.adt.ADTSymbolNode;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Predicate;
import net.automatalib.automaton.transducer.MealyMachine;
import net.automatalib.common.util.Pair;
import net.automatalib.graph.ads.ADSNode;
import net.automatalib.util.automaton.ads.ADSUtil;
import net.automatalib.word.Word;
import org.checkerframework.checker.nullness.qual.Nullable;

public final class ADTUtil {
    private ADTUtil() {
    }

    public static boolean isLeafNode(@Nullable ADTNode<?, ?, ?> node) {
        return ADTUtil.checkNodeType(node, ADTNode.NodeType.LEAF_NODE);
    }

    public static boolean isResetNode(@Nullable ADTNode<?, ?, ?> node) {
        return ADTUtil.checkNodeType(node, ADTNode.NodeType.RESET_NODE);
    }

    public static boolean isSymbolNode(@Nullable ADTNode<?, ?, ?> node) {
        return ADTUtil.checkNodeType(node, ADTNode.NodeType.SYMBOL_NODE);
    }

    private static boolean checkNodeType(@Nullable ADTNode<?, ?, ?> node, ADTNode.NodeType type) {
        return node != null && node.getNodeType() == type;
    }

    public static <S, I, O> ADTNode<S, I, O> getStartOfADS(ADTNode<S, I, O> node) {
        ADTNode result = node;
        for (ADTNode iter = (ADTNode)node.getParent(); iter != null && !ADTUtil.isResetNode(iter); iter = (ADTNode)iter.getParent()) {
            result = iter;
        }
        return result;
    }

    public static <S> Set<S> collectHypothesisStates(ADTNode<S, ?, ?> root) {
        LinkedHashSet result = new LinkedHashSet();
        ADTUtil.collectHypothesisStatesRecursively(result, root);
        return result;
    }

    private static <S> void collectHypothesisStatesRecursively(Set<S> nodes, ADTNode<S, ?, ?> current) {
        if (ADTUtil.isLeafNode(current)) {
            nodes.add(current.getState());
        } else {
            for (ADTNode n : current.getChildren().values()) {
                ADTUtil.collectHypothesisStatesRecursively(nodes, n);
            }
        }
    }

    public static <S, I, O> Set<ADTNode<S, I, O>> collectLeaves(ADTNode<S, I, O> root) {
        LinkedHashSet<ADTNode<S, I, O>> result = new LinkedHashSet<ADTNode<S, I, O>>();
        ADTUtil.collectNodesRecursively(result, root, ADTNode.NodeType.LEAF_NODE);
        return result;
    }

    public static <S, I, O> Set<ADTNode<S, I, O>> collectResetNodes(ADTNode<S, I, O> root) {
        LinkedHashSet<ADTNode<S, I, O>> result = new LinkedHashSet<ADTNode<S, I, O>>();
        ADTUtil.collectNodesRecursively(result, root, ADTNode.NodeType.RESET_NODE);
        return result;
    }

    private static <S, I, O> void collectNodesRecursively(Set<ADTNode<S, I, O>> nodes, ADTNode<S, I, O> current, ADTNode.NodeType type) {
        if (current.getNodeType() == type) {
            nodes.add(current);
        }
        for (ADTNode n : current.getChildren().values()) {
            ADTUtil.collectNodesRecursively(nodes, n, type);
        }
    }

    public static <S, I, O> Set<ADTNode<S, I, O>> collectADSNodes(ADTNode<S, I, O> root, boolean includeRoot) {
        LinkedHashSet<ADTNode<S, I, O>> result = new LinkedHashSet<ADTNode<S, I, O>>();
        if (includeRoot) {
            result.add(root);
        }
        ADTUtil.collectADSNodesRecursively(result, root);
        return result;
    }

    private static <S, I, O> void collectADSNodesRecursively(Set<ADTNode<S, I, O>> nodes, ADTNode<S, I, O> current) {
        if (ADTUtil.isResetNode(current)) {
            nodes.addAll(current.getChildren().values());
        }
        for (ADTNode n : current.getChildren().values()) {
            ADTUtil.collectADSNodesRecursively(nodes, n);
        }
    }

    public static <S, I, O> Set<ADTNode<S, I, O>> collectDirectSubADSs(ADTNode<S, I, O> node) {
        LinkedHashSet<ADTNode<S, I, O>> result = new LinkedHashSet<ADTNode<S, I, O>>();
        ADTUtil.collectDirectSubTreesRecursively(result, node);
        return result;
    }

    private static <S, I, O> void collectDirectSubTreesRecursively(Set<ADTNode<S, I, O>> nodes, ADTNode<S, I, O> current) {
        if (ADTUtil.isResetNode(current)) {
            nodes.addAll(current.getChildren().values());
        } else {
            for (ADTNode n : current.getChildren().values()) {
                ADTUtil.collectDirectSubTreesRecursively(nodes, n);
            }
        }
    }

    public static <S, I, O> Pair<Word<I>, Word<O>> buildTraceForNode(ADTNode<S, I, O> node) {
        Predicate<ADTNode> predicate = ADTUtil::isResetNode;
        return ADSUtil.buildTraceForNode(node, predicate.negate());
    }

    public static <S, I, O> O getOutputForSuccessor(ADTNode<S, I, O> node, ADTNode<S, I, O> successor) {
        return (O)ADSUtil.getOutputForSuccessor(node, successor);
    }

    public static <S, I, O> ADTNode<S, I, O> buildFromADS(ADSNode<S, I, O> node) {
        if (node.isLeaf()) {
            return new ADTLeafNode(null, node.getState());
        }
        ADTSymbolNode result = new ADTSymbolNode(null, node.getSymbol());
        for (Map.Entry entry : node.getChildren().entrySet()) {
            Object adsOutput = entry.getKey();
            ADSNode adsNode = (ADSNode)entry.getValue();
            ADTNode<S, I, O> newChild = ADTUtil.buildFromADS(adsNode);
            newChild.setParent(result);
            result.getChildren().put(adsOutput, newChild);
        }
        return result;
    }

    public static int computeEffectiveResets(ADTNode<?, ?, ?> adt) {
        return ADTUtil.computeEffectiveResetsInternal(adt, 0);
    }

    private static int computeEffectiveResetsInternal(ADTNode<?, ?, ?> ads, int accumulatedResets) {
        if (ADTUtil.isLeafNode(ads)) {
            return accumulatedResets;
        }
        int nextCosts = ADTUtil.isResetNode(ads) ? accumulatedResets + 1 : accumulatedResets;
        int resets = 0;
        for (ADTNode value : ads.getChildren().values()) {
            resets += ADTUtil.computeEffectiveResetsInternal(value, nextCosts);
        }
        return resets;
    }

    public static <S, I, O> Pair<ADTNode<S, I, O>, ADTNode<S, I, O>> buildADSFromTrace(MealyMachine<S, I, ?, O> automaton, Word<I> trace, S state) {
        return ADSUtil.buildFromTrace(automaton, trace, state, ADTSymbolNode::new);
    }

    public static <S, I, O> ADTNode<S, I, O> buildADSFromObservation(Word<I> input, Word<O> output, S finalState) {
        ADTSymbolNode result;
        if (input.size() != output.size()) {
            throw new IllegalArgumentException("Arguments differ in length");
        }
        Iterator inputIterator = input.iterator();
        Iterator outputIterator = output.iterator();
        ADTSymbolNode nodeIter = result = new ADTSymbolNode(null, inputIterator.next());
        while (inputIterator.hasNext()) {
            ADTSymbolNode nextNode = new ADTSymbolNode(nodeIter, inputIterator.next());
            nodeIter.getChildren().put(outputIterator.next(), nextNode);
            nodeIter = nextNode;
        }
        ADTLeafNode finalNode = new ADTLeafNode(nodeIter, finalState);
        nodeIter.getChildren().put(outputIterator.next(), finalNode);
        return result;
    }

    public static <S, I, O> boolean mergeADS(ADTNode<S, I, O> parent, ADTNode<S, I, O> child) {
        ADTNode parentIter = parent;
        ADTNode childIter = child;
        while (!(ADTUtil.isLeafNode(parentIter) || ADTUtil.isResetNode(parentIter) || ADTUtil.isLeafNode(childIter))) {
            if (!Objects.equals(parentIter.getSymbol(), childIter.getSymbol())) {
                return false;
            }
            Map childSuccessors = childIter.getChildren();
            if (childSuccessors.size() != 1) {
                throw new IllegalArgumentException("No single trace child");
            }
            Map parentSuccessors = parentIter.getChildren();
            Map.Entry childSuccessor = childSuccessors.entrySet().iterator().next();
            Object childOutput = childSuccessor.getKey();
            ADTNode childADS = (ADTNode)childSuccessor.getValue();
            if (!parentSuccessors.containsKey(childOutput)) {
                parentSuccessors.put(childOutput, childADS);
                childADS.setParent(parentIter);
                return true;
            }
            parentIter = (ADTNode)parentSuccessors.get(childOutput);
            childIter = childADS;
        }
        return false;
    }
}

