/*
 * Decompiled with CFR 0.152.
 */
package de.learnlib.algorithm.adt.model;

import de.learnlib.algorithm.adt.adt.ADTNode;
import de.learnlib.algorithm.adt.util.ADTUtil;
import de.learnlib.filter.cache.mealy.AdaptiveQueryCache;
import de.learnlib.oracle.AdaptiveMembershipOracle;
import de.learnlib.query.AdaptiveQuery;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import net.automatalib.alphabet.Alphabet;
import net.automatalib.alphabet.SupportsGrowingAlphabet;
import net.automatalib.automaton.UniversalDeterministicAutomaton;
import net.automatalib.automaton.transducer.MealyMachine;
import net.automatalib.common.util.Pair;
import net.automatalib.util.automaton.equivalence.NearLinearEquivalenceTest;
import net.automatalib.word.Word;
import org.checkerframework.checker.nullness.qual.Nullable;

public class ObservationTree<S, I, O>
implements AdaptiveMembershipOracle<I, O>,
SupportsGrowingAlphabet<I> {
    private final Alphabet<I> alphabet;
    private final AdaptiveMembershipOracle<I, O> delegate;
    private final AdaptiveQueryCache<I, O> cache;
    private final Integer init;
    private final Map<S, Integer> nodeToObservationMap;

    public ObservationTree(Alphabet<I> alphabet, AdaptiveMembershipOracle<I, O> delegate, boolean useCache) {
        this.cache = new AdaptiveQueryCache(delegate, alphabet);
        this.init = this.cache.getInit();
        this.delegate = useCache ? this.cache : delegate;
        this.alphabet = alphabet;
        this.nodeToObservationMap = new HashMap<S, Integer>();
    }

    public void initialize(S state) {
        this.nodeToObservationMap.put(state, this.init);
    }

    public void initialize(Collection<S> states, Function<S, Word<I>> asFunction, Function<Word<I>, Word<O>> outputFunction) {
        for (S s : states) {
            Word<I> as = asFunction.apply(s);
            Integer treeNode = this.addTrace(this.init, as, outputFunction.apply(as));
            this.nodeToObservationMap.put(s, treeNode);
        }
    }

    public void addTrace(S state, Word<I> input, Word<O> output) {
        this.addTrace(this.nodeToObservationMap.get(state), input, output);
    }

    private Integer addTrace(Integer state, Word<I> input, Word<O> output) {
        return this.cache.insert(state, input, output);
    }

    public void addTrace(S state, ADTNode<S, I, O> adtNode) {
        Integer internalState = this.nodeToObservationMap.get(state);
        ADTNode adsIter = adtNode;
        while (adsIter != null) {
            Pair<Word<I>, Word<O>> trace = ADTUtil.buildTraceForNode(adsIter);
            this.addTrace(internalState, (Word)trace.getFirst(), (Word)trace.getSecond());
            adsIter = (ADTNode)ADTUtil.getStartOfADS(adsIter).getParent();
        }
    }

    public void addState(S newState, Word<I> accessSequence, O output) {
        Word prefix = accessSequence.prefix(accessSequence.length() - 1);
        Object sym = accessSequence.lastSymbol();
        Integer pred = (Integer)this.cache.getCache().getState((Iterable)prefix);
        Integer target = this.cache.insert(pred, Word.fromLetter((Object)sym), Word.fromLetter(output));
        this.nodeToObservationMap.put(newState, target);
    }

    public @Nullable Word<I> findSeparatingWord(S s1, S s2, Word<I> prefix) {
        MealyMachine cache = this.cache.getCache();
        Integer n1 = this.nodeToObservationMap.get(s1);
        Integer n2 = this.nodeToObservationMap.get(s2);
        Integer s1Succ = (Integer)cache.getSuccessor((Object)n1, prefix);
        Integer s2Succ = (Integer)cache.getSuccessor((Object)n2, prefix);
        if (s1Succ != null && s2Succ != null) {
            return NearLinearEquivalenceTest.findSeparatingWord((UniversalDeterministicAutomaton)cache, (Object)s1Succ, (Object)s2Succ, this.alphabet, (boolean)true);
        }
        return null;
    }

    public @Nullable Word<I> findSeparatingWord(S s1, S s2) {
        Integer n1 = this.nodeToObservationMap.get(s1);
        Integer n2 = this.nodeToObservationMap.get(s2);
        return NearLinearEquivalenceTest.findSeparatingWord((UniversalDeterministicAutomaton)this.cache.getCache(), (Object)n1, (Object)n2, this.alphabet, (boolean)true);
    }

    public Word<O> trace(S s, Word<I> input) {
        Integer q = this.nodeToObservationMap.get(s);
        return this.cache.getCache().computeStateOutput((Object)q, input);
    }

    public void processQueries(Collection<? extends AdaptiveQuery<I, O>> queries) {
        this.delegate.processQueries(queries);
    }

    public void addAlphabetSymbol(I i) {
        this.alphabet.asGrowingAlphabetOrThrowException().add(i);
        this.cache.addAlphabetSymbol(i);
    }
}

