/*
 * Decompiled with CFR 0.152.
 */
package de.learnlib.algorithm.adt.learner;

import de.learnlib.algorithm.adt.adt.ADTNode;
import de.learnlib.algorithm.adt.automaton.ADTState;
import de.learnlib.algorithm.adt.util.ADTUtil;
import de.learnlib.query.AdaptiveQuery;

abstract class AbstractAdaptiveQuery<I, O>
implements AdaptiveQuery<I, O> {
    protected ADTNode<ADTState<I, O>, I, O> currentADTNode;
    private O tempOut;

    AbstractAdaptiveQuery(ADTNode<ADTState<I, O>, I, O> currentADTNode) {
        this.currentADTNode = currentADTNode;
    }

    public AdaptiveQuery.Response processOutput(O out) {
        ADTNode<ADTState<I, Object>, I, Object> succ = this.currentADTNode.getChild(out);
        if (succ == null) {
            this.tempOut = out;
            return AdaptiveQuery.Response.FINISHED;
        }
        if (ADTUtil.isResetNode(succ)) {
            this.currentADTNode = succ.getChild(null);
            this.resetProgress();
            return AdaptiveQuery.Response.RESET;
        }
        if (ADTUtil.isSymbolNode(succ)) {
            this.currentADTNode = succ;
            return AdaptiveQuery.Response.SYMBOL;
        }
        this.currentADTNode = succ;
        return AdaptiveQuery.Response.FINISHED;
    }

    protected abstract void resetProgress();

    boolean needsPostProcessing() {
        return this.tempOut != null;
    }

    ADTNode<ADTState<I, O>, I, O> getCurrentADTNode() {
        return this.currentADTNode;
    }

    O getTempOut() {
        return this.tempOut;
    }
}

